---
generated_at: 2026-01-22 13:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：65-脆弱性スキャン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **EE機能の詳細実装**：Community Editionのコードベースからは一部機能の詳細が確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/vulnerability.rb`
- E-02: `app/models/concerns/enums/vulnerability.rb`
- E-03: `lib/gitlab/ci/reports/security/report.rb`
- E-04: `lib/gitlab/ci/reports/security/finding.rb`
- E-05: `app/controllers/projects/security/configuration_controller.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 信頼度は7段階（ignore, unknown, experimental, low, medium, high, confirmed） | E-02 (5-14行目: CONFIDENCE_LEVELS) | ○ |
| C-02 | 重大度は6段階（info, unknown, low, medium, high, critical） | E-02 (21-30行目: SEVERITY_LEVELS) | ○ |
| C-03 | 状態は4種類（detected, confirmed, resolved, dismissed） | E-02 (43-48行目: VULNERABILITY_STATES) | ○ |
| C-04 | OWASP Top 10（2017/2021）に基づく分類をサポート | E-02 (50-92行目: OWASP_TOP_10_BY_YEAR) | ○ |
| C-05 | レポートタイプにsast、secret_detectionがある | E-02 (16-19行目: REPORT_TYPES) | ○ |
| C-06 | 検出方法は5種類（gitlab_security_report, external_security_report等） | E-02 (32-38行目: DETECTION_METHODS) | ○ |
| C-07 | Findingには必須キーがある | E-04 (11-21行目: REQUIRED_KEYS) | ○ |
| C-08 | Findingの同一性判定はreport_type、識別子、位置情報で行う | E-04 (116-124行目: eql?メソッド) | ○ |
| C-09 | Findingのハッシュ計算はreport_type、location.fingerprint、identifier_fingerprintで行う | E-04 (126-133行目: hashメソッド) | ○ |
| C-10 | Findingの有効性チェックはscanner, primary_identifier, location, uuidの存在確認 | E-04 (135-137行目: valid?メソッド) | ○ |
| C-11 | Reportにfinding、identifierを追加できる | E-03 (48-54行目: add_identifier, add_finding) | ○ |
| C-12 | read_security_configuration権限でセキュリティ設定閲覧可能 | E-05 (12行目) | ○ |
| C-13 | feature_categoryはstatic_application_security_testing | E-05 (8行目) | ○ |
| C-14 | CVSSベクトルのバリデーションがある | E-01 (16行目: validates :cvss, json_schema) | ○ |
| C-15 | 脆弱性ステータス管理の詳細実装 | **EE機能のため要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- GitLab EEにおける脆弱性管理の詳細実装
  - 候補：GitLab EEコードベース / セキュリティ機能ドキュメント

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 本機能の主要部分はGitLab EEで実装されている
- 0: 低リスク - enum定義、レポート解析等の基盤部分はCEで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GitLab EEの脆弱性管理機能の詳細を確認
- [ ] サポートするセキュリティスキャナの種類を確認
- [ ] レポートスキーマのバージョンを確認
- [ ] 脆弱性ステータス遷移のワークフローを確認
