---
generated_at: 2026-01-22 13:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-依存関係スキャン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/concerns/enums/sbom.rb`
- E-02: `app/models/concerns/enums/security.rb`
- E-03: `app/models/concerns/enums/ci/job_artifact.rb`
- E-04: `lib/gitlab/ci/templates/Jobs/Dependency-Scanning.gitlab-ci.yml`
- E-05: `lib/security/ci_configuration/base_build_action.rb`
- E-06: `lib/security/ci_configuration/dependency_scanning_build_action.rb`
- E-07: `app/services/security/ci_configuration/dependency_scanning_create_service.rb`
- E-08: `lib/gitlab/ci/reports/security/finding.rb`
- E-09: `lib/gitlab/ci/reports/security/report.rb`
- E-10: `lib/gitlab/ci/config/entry/reports.rb`
- E-11: `app/finders/security/jobs_finder.rb`
- E-12: `app/finders/security/security_jobs_finder.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サポートPURL種別は12種類（composer, conan, gem, golang, maven, npm, nuget, pypi, cargo, swift, conda, pub） | E-01 (55-68行目: DEPENDENCY_SCANNING_PURL_TYPES) | ○ |
| C-02 | アナライザー種別にdependency_scanningがある（値: 4） | E-02 (7-18行目: ANALYZER_TYPES) | ○ |
| C-03 | デフォルトファイル名はgl-dependency-scanning-report.json | E-03 (29行目: DEFAULT_FILE_NAMES) | ○ |
| C-04 | file_typeのenum値は6 | E-03 (164行目: file_type) | ○ |
| C-05 | DS_EXCLUDED_PATHSのデフォルトはspec, test, tests, tmp, node_modules | E-04 (17行目) | ○ |
| C-06 | DS_MAJOR_VERSIONのデフォルトは6 | E-04 (18行目) | ○ |
| C-07 | DS_SCHEMA_MODELのデフォルトは15 | E-04 (19行目) | ○ |
| C-08 | gemnasiumの対象ファイルはGemfile.lock, composer.lock, go.sum等 | E-04 (60-62行目: .gemnasium-shared-rule) | ○ |
| C-09 | gemnasium-mavenの対象ファイルはbuild.gradle, pom.xml等 | E-04 (116-118行目: .gemnasium-maven-shared-rule) | ○ |
| C-10 | gemnasium-pythonの対象ファイルはrequirements.txt, poetry.lock等 | E-04 (170-172行目: .gemnasium-python-shared-rule) | ○ |
| C-11 | DEPENDENCY_SCANNING_DISABLED=trueでスキャン無効化 | E-04 (72-73行目, 127-128行目, 181-182行目) | ○ |
| C-12 | FIPSモード時は専用イメージを使用 | E-04 (83-90行目: CI_GITLAB_FIPS_MODE) | ○ |
| C-13 | アーティファクトアクセスはdeveloper以上 | E-04 (27行目, 54行目: access: 'developer') | ○ |
| C-14 | テンプレートはSecurity/Dependency-Scanning.gitlab-ci.yml | E-06 (16行目: template) | ○ |
| C-15 | ブランチ名はset-dependency-scanning-config | E-07 (17行目: next_branch) | ○ |
| C-16 | CIテンプレートのinclude生成 | E-05 (26-31行目: generate_includes) | ○ |
| C-17 | Findingの必須キーにreport_type, scanner, uuid等がある | E-08 (11-21行目: REQUIRED_KEYS) | ○ |
| C-18 | Reportにfindingを追加できる | E-09 (52-54行目: add_finding) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] gemnasiumアナライザーのバージョン互換性を確認
- [ ] DS_EXCLUDED_PATHSのカスタマイズが運用要件に適合しているか確認
- [ ] FIPSモード対応が必要な環境で正しく動作するか確認
- [ ] CycloneDX SBOM形式の出力が要件を満たしているか確認
- [ ] GitLab Advisory Databaseとの接続設定を確認
