---
generated_at: 2026-01-22 13:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-シークレット検出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/concerns/enums/ci/job_artifact.rb`
- E-02: `app/models/concerns/enums/security.rb`
- E-03: `lib/gitlab/ci/templates/Jobs/Secret-Detection.gitlab-ci.yml`
- E-04: `lib/security/ci_configuration/secret_detection_build_action.rb`
- E-05: `app/services/security/ci_configuration/secret_detection_create_service.rb`
- E-06: `app/services/security/ci_configuration/base_create_service.rb`
- E-07: `lib/gitlab/ci/parsers/security/secret_detection.rb`
- E-08: `lib/gitlab/ci/reports/security/locations/secret_detection.rb`
- E-09: `app/assets/javascripts/lib/utils/secret_detection_patterns.js`
- E-10: `app/assets/javascripts/lib/utils/secret_detection.js`
- E-11: `app/graphql/mutations/security/ci_configuration/configure_secret_detection.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトファイル名はgl-secret-detection-report.json | E-01 (28行目: DEFAULT_FILE_NAMES) | ○ |
| C-02 | file_typeのenum値は21 | E-01 (179行目: file_type) | ○ |
| C-03 | REPORT_TYPESでsecret_detection: :raw | E-01 (78行目) | ○ |
| C-04 | アナライザー種別のsecret_detectionは値6 | E-02 (14行目: ANALYZER_TYPES) | ○ |
| C-05 | SECRETS_ANALYZER_VERSIONのデフォルトは7 | E-03 (13行目) | ○ |
| C-06 | GIT_DEPTHのデフォルトは50 | E-03 (22行目) | ○ |
| C-07 | アーティファクトアクセスはdeveloper以上 | E-03 (26行目: access: 'developer') | ○ |
| C-08 | SECRET_DETECTION_DISABLED=trueでスキャン無効化 | E-03 (34行目) | ○ |
| C-09 | テンプレートはSecurity/Secret-Detection.gitlab-ci.yml | E-04 (70行目: template) | ○ |
| C-10 | ステージ名はsecret-detection | E-04 (63-65行目: secret_detection_stage) | ○ |
| C-11 | 設定可能変数にSECRET_DETECTION_HISTORIC_SCAN等がある | E-04 (80-86行目: secret_detection_variables) | ○ |
| C-12 | ブランチ名はset-secret-detection-config | E-05 (30-32行目: next_branch) | ○ |
| C-13 | リポジトリ空の場合はエラー | E-06 (17-32行目: execute) | ○ |
| C-14 | 位置情報にfile_path, start_line, end_lineがある | E-08 (17-23行目: initialize) | ○ |
| C-15 | フィンガープリントはfile_path:start_line:end_line形式 | E-08 (25-27行目: fingerprint_data) | ○ |
| C-16 | GitLab PATパターンはglpat-[0-9a-zA-Z_-]{20} | E-09 (7-9行目) | ○ |
| C-17 | Deploy Tokenパターンはgldt-[0-9a-zA-Z_-]{20} | E-09 (23-25行目) | ○ |
| C-18 | Pipeline Trigger Tokenパターンはglptt-[0-9a-zA-Z_-]{40} | E-09 (55-57行目) | ○ |
| C-19 | containsSensitiveTokenでパターンマッチング | E-10 (58-79行目) | ○ |
| C-20 | GraphQL MutationでSecretDetectionCreateServiceを呼び出す | E-11 (15-17行目: configure_analyzer) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 検出パターンが最新のGitLabトークン形式に対応しているか確認
- [ ] SECRET_DETECTION_EXCLUDED_PATHSの設定が運用要件に適合しているか確認
- [ ] 履歴スキャン（SECRET_DETECTION_HISTORIC_SCAN）の実行時間が許容範囲か確認
- [ ] クライアントサイド検出のパフォーマンス影響を確認
- [ ] 検出されたシークレットの無効化フローが運用に適合しているか確認
