---
generated_at: 2026-01-22 13:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-Wiki閲覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/wiki.rb`
- E-02: `app/models/wiki_page.rb`
- E-03: `app/controllers/concerns/wiki_actions.rb`
- E-04: `app/policies/wiki_policy.rb`
- E-05: `app/policies/wiki_page_policy.rb`
- E-06: `app/graphql/resolvers/wikis/wiki_page_resolver.rb`
- E-07: `app/graphql/types/wikis/wiki_page_type.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サポートマークアップは10種類（Markdown, RDoc, AsciiDoc等） | E-01 (13-68行目: MARKUPS) | ○ |
| C-02 | ユーザー作成可能形式は4種類 | E-01 (70行目: VALID_USER_MARKUPS, created_by_user: true) | ○ |
| C-03 | ホームページスラッグは"home" | E-01 (78行目: HOMEPAGE = 'home') | ○ |
| C-04 | サイドバーは"_sidebar" | E-01 (79行目: SIDEBAR = '_sidebar') | ○ |
| C-05 | テンプレートディレクトリは"templates" | E-01 (80行目: TEMPLATES_DIR = 'templates') | ○ |
| C-06 | リダイレクト設定は".gitlab/redirects.yml" | E-01 (81行目: REDIRECTS_YML) | ○ |
| C-07 | list_pagesでページ一覧取得 | E-01 (216-247行目) | ○ |
| C-08 | find_pageでページ検索 | E-01 (256-284行目) | ○ |
| C-09 | 予約スラッグは5種類（pages, templates, new, git_access, -） | E-02 (15-21行目: RESERVED_SLUGS) | ○ |
| C-10 | versionsでコミット履歴取得 | E-02 (216-228行目) | ○ |
| C-11 | validate_path_limitsでバイト数バリデーション | E-02 (464-482行目) | ○ |
| C-12 | RESCUE_GIT_TIMEOUTS_INでタイムアウト対象アクション定義 | E-03 (13行目) | ○ |
| C-13 | authorize_read_wiki!で権限チェック | E-03 (28行目: before_action) | ○ |
| C-14 | load_sidebarでサイドバー読み込み | E-03 (361-364行目) | ○ |
| C-15 | find_redirectionでリダイレクト検索 | E-03 (449-468行目) | ○ |
| C-16 | WikiPolicyはコンテナに権限を委譲 | E-04 (5行目: delegate) | ○ |
| C-17 | read_wiki権限でread_wiki_page等を許可 | E-05 (10-15行目) | ○ |
| C-18 | GraphQLでread_wiki権限による認可 | E-07 (13行目: authorize :read_wiki) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] サポートマークアップ形式が運用要件を満たしているか確認
- [ ] wiki_page_max_content_bytesの設定が適切か確認
- [ ] リダイレクト機能が正常に動作するか確認
- [ ] Gitalyタイムアウト時の挙動が適切か確認
- [ ] 権限設定がセキュリティ要件を満たしているか確認
