---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-Wikiページ作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/wiki_pages/base_service.rb`
- E-02: `app/services/wiki_pages/create_service.rb`
- E-03: `app/services/wiki_pages/update_service.rb`
- E-04: `app/services/wiki_pages/destroy_service.rb`
- E-05: `app/services/wikis/create_attachment_service.rb`
- E-06: `app/models/wiki.rb`
- E-07: `app/models/wiki_page.rb`
- E-08: `app/controllers/concerns/wiki_actions.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateServiceのinternal_event_nameはcreate_wiki_page | E-02 (18-19行目) | ○ |
| C-02 | CreateServiceのexternal_actionはcreate | E-02 (22-24行目) | ○ |
| C-03 | CreateServiceのevent_actionは:created | E-02 (26-28行目) | ○ |
| C-04 | UpdateServiceのinternal_event_nameはupdate_wiki_page | E-03 (27-29行目) | ○ |
| C-05 | UpdateServiceで楽観的ロックチェック | E-03 (18行目: PageChangedError) | ○ |
| C-06 | DestroyServiceのinternal_event_nameはdelete_wiki_page | E-04 (15-17行目) | ○ |
| C-07 | DestroyServiceのevent_actionは:destroyed | E-04 (23-25行目) | ○ |
| C-08 | execute_hooksでWebhook実行 | E-01 (14-20行目) | ○ |
| C-09 | track_wiki_eventで内部イベント記録 | E-01 (62-74行目) | ○ |
| C-10 | ATTACHMENT_PATHはuploads | E-05 (5行目) | ○ |
| C-11 | MAX_FILENAME_LENGTHは255 | E-05 (6行目) | ○ |
| C-12 | 添付ファイル名のサニタイズ処理 | E-05 (33-39行目: clean_file_name) | ○ |
| C-13 | create_wiki権限でのバリデーション | E-05 (60-64行目: validate_permissions!) | ○ |
| C-14 | Wiki#create_pageでページ作成 | E-06 (301-329行目) | ○ |
| C-15 | Wiki#update_pageでページ更新 | E-06 (331-360行目) | ○ |
| C-16 | Wiki#delete_pageでページ削除 | E-06 (362-373行目) | ○ |
| C-17 | validate_path_limitsでパスバイト数チェック | E-07 (464-482行目) | ○ |
| C-18 | validate_content_size_limitでサイズチェック | E-07 (484-493行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] wiki_page_max_content_bytesの設定が運用要件を満たしているか確認
- [ ] Front Matter上限（16KB）が適切か確認
- [ ] 楽観的ロック機能が正常に動作するか確認
- [ ] Webhookの送信先設定が正しいか確認
- [ ] 添付ファイルのサニタイズ処理が十分か確認
