---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-Wiki履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/concerns/wiki_actions.rb`
- E-02: `app/models/wiki_page.rb`
- E-03: `lib/gitlab/diff/file_collection/wiki_page.rb`
- E-04: `app/helpers/wiki_page_version_helper.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | historyアクションでコミット履歴表示 | E-01 (260-274行目) | ○ |
| C-02 | count_versionsでコミット総数取得 | E-01 (262行目) | ○ |
| C-03 | page.versionsでページネーション対応 | E-01 (263-265行目) | ○ |
| C-04 | diffアクションで差分表示 | E-01 (277-287行目) | ○ |
| C-05 | diff_notes_disabled = true | E-01 (284行目) | ○ |
| C-06 | historyとdiffがタイムアウト対象 | E-01 (13行目: RESCUE_GIT_TIMEOUTS_IN) | ○ |
| C-07 | WikiPage#versionsでコミット履歴取得 | E-02 (216-228行目) | ○ |
| C-08 | WikiPage#count_versionsでカウント | E-02 (230-234行目) | ○ |
| C-09 | WikiPage#historical?で過去バージョン判定 | E-02 (250-254行目) | ○ |
| C-10 | WikiPage#diffsで差分取得 | E-02 (394-396行目) | ○ |
| C-11 | diff_optionsにexpanded: true | E-03 (10行目) | ○ |
| C-12 | diff_optionsにpaths: [page.path] | E-03 (11行目) | ○ |
| C-13 | ユーザー存在時はプロフィールURL | E-04 (8行目) | ○ |
| C-14 | ユーザー不在時はmailto:リンク | E-04 (8行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ページネーションの件数設定が適切か確認
- [ ] 大量の履歴がある場合のパフォーマンスを確認
- [ ] Gitalyタイムアウト時の挙動が適切か確認
- [ ] 差分表示のUI/UXが要件を満たしているか確認
- [ ] 過去バージョンへのリンクが正しく機能するか確認
