---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：72-個人スニペット機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/snippets_controller.rb`
- E-02: `app/models/snippet.rb`
- E-03: `app/services/snippets/create_service.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 個人スニペットはプロジェクトに紐づかない | E-01, E-03 (59-62行目) | ○ |
| C-02 | indexアクセス時、ログイン状態でリダイレクト先が変わる | E-01 (19-21行目) | ○ |
| C-03 | newアクションでPersonalSnippetオブジェクトを作成 | E-01 (23-25行目) | ○ |
| C-04 | determine_layoutで作成者判定によりレイアウト切り替え | E-01 (36-42行目) | ○ |
| C-05 | 一覧・詳細表示は認証不要（skip_before_action） | E-01 (15行目) | ○ |
| C-06 | ToggleAwardEmojiをinclude | E-01 (6行目) | ○ |
| C-07 | PreviewMarkdownをinclude | E-01 (5行目) | ○ |
| C-08 | スパムチェック機能（Akismet） | E-01 (7行目) | ○ |
| C-09 | タイトル最大255文字 | E-02 (60行目) | ○ |
| C-10 | 説明最大1MB | E-02 (27, 63行目) | ○ |
| C-11 | コンテンツ必須 | E-02 (65行目) | ○ |
| C-12 | 組織への紐付け（organization_id） | E-03 (60-61, 65-67行目) | ○ |
| C-13 | move_temporary_filesでファイル関連付け変更 | E-03 (119-125行目) | ○ |
| C-14 | PersonalSnippetはFileMover使用 | E-03 (122-124行目) | ○ |
| C-15 | 秘密のスニペット機能あり（secret属性） | E-02 (77, 102-105行目) | ○ |
| C-16 | embeddable?メソッドで埋め込み可否判定 | E-02 (281-283行目) | ○ |
| C-17 | 関連画面No.17, 21, 279-281 | E-04 | ○ |
| C-18 | STI（Single Table Inheritance）実装 | E-02, E-03 | ○ |
| C-19 | project_idがNULLで個人スニペット判定 | E-02 (135-137行目) | ○ |
| C-20 | リポジトリとして管理される | E-03 (107-110行目) | ○ |
| C-21 | snippet_repositoriesテーブル関連 | E-02 (51行目) | ○ |
| C-22 | パフォーマンス要件（1秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードからは確認できない。運用要件の確認が必要。
  - 候補：非機能要件定義書 / 性能テスト仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要と処理フロー（コードから明確に確認可能）
- 0: 低リスク - レイアウト切り替えロジック（コードから明確）
- 1: 中リスク - パフォーマンス要件（根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（1秒以内のレスポンス）が実運用要件と一致するか確認
- [ ] 組織（Organization）への紐付けが必須かどうかの確認
- [ ] 秘密のスニペット機能の詳細動作確認
