---
generated_at: 2026-01-22 12:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：73-リリース作成機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/releases_controller.rb`
- E-02: `app/models/release.rb`
- E-03: `app/services/releases/create_service.rb`
- E-04: `app/services/releases/create_evidence_service.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リリースはGitタグと連動 | E-02 (32行目 validates :tag) | ○ |
| C-02 | authorize_read_release!で閲覧権限確認 | E-01 (7行目) | ○ |
| C-03 | authorize_create_release!で作成権限確認 | E-01 (9行目) | ○ |
| C-04 | indexでHTML/JSON/Atom対応 | E-01 (20-33行目) | ○ |
| C-05 | downloadsアクションでアセットダウンロード | E-01 (35-43行目) | ○ |
| C-06 | 権限チェック（Ability.allowed?） | E-03 (6行目, 52-54行目) | ○ |
| C-07 | 保護タグへの作成権限チェック | E-03 (7行目, 56-58行目) | ○ |
| C-08 | 既存リリースチェック（409エラー） | E-03 (8行目) | ○ |
| C-09 | マイルストーン存在確認 | E-03 (10-19行目) | ○ |
| C-10 | エビデンスパイプライン取得 | E-03 (25行目) | ○ |
| C-11 | タグ確保（ensure_tag） | E-03 (27行目, 36-50行目) | ○ |
| C-12 | ref未指定時は422エラー | E-03 (41行目) | ○ |
| C-13 | Tags::CreateServiceでタグ作成 | E-03 (43-49行目) | ○ |
| C-14 | 通知送信（NotificationService） | E-03 (71, 84-86行目) | ○ |
| C-15 | Webhook実行（execute_hooks） | E-03 (73行目) | ○ |
| C-16 | エビデンス作成（非同期ワーカー） | E-03 (75, 107-111行目) | ○ |
| C-17 | 監査ログ記録 | E-03 (77行目) | ○ |
| C-18 | カタログ公開処理 | E-03 (63-67行目, 113-117行目) | ○ |
| C-19 | name未指定時はタグ名をリリース名として使用 | E-02 (147-149行目) | ○ |
| C-20 | released_at未指定時はcreated_atを使用 | E-02 (184-186行目) | ○ |
| C-21 | upcoming_release?メソッド | E-02 (139-141行目) | ○ |
| C-22 | historical_release?メソッド | E-02 (143-145行目) | ○ |
| C-23 | historical/upcomingリリースはエビデンス生成しない | E-03 (108行目) | ○ |
| C-24 | project, tag必須バリデーション | E-02 (32行目) | ○ |
| C-25 | author_id必須（作成時） | E-02 (33行目) | ○ |
| C-26 | タグ一意制約（scope: project_id） | E-02 (35行目) | ○ |
| C-27 | 関連画面No.85-88, 39 | E-05 | ○ |
| C-28 | パフォーマンス要件（5秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードからは確認できない。
  - 候補：非機能要件定義書 / 性能テスト仕様書 / SLA定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要と処理フロー（コードから明確に確認可能）
- 0: 低リスク - 権限チェックロジック（コードから明確）
- 0: 低リスク - エビデンス生成条件（コードから明確）
- 1: 中リスク - パフォーマンス要件（根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（5秒以内）が実運用要件と一致するか確認
- [ ] カタログ公開処理の詳細動作確認
- [ ] 外部URLリダイレクト警告の実装確認
