---
generated_at: 2026-01-22 12:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-リリースアセット機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/releases/link.rb`
- E-02: `app/models/release.rb`
- E-03: `app/controllers/projects/releases_controller.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | release_linksテーブルを使用 | E-01 (5行目) | ○ |
| C-02 | releaseへのbelongs_to関連 | E-01 (7行目) | ○ |
| C-03 | URL必須バリデーション | E-01 (14行目) | ○ |
| C-04 | URL形式チェック（http/https/ftp） | E-01 (14行目 schemes) | ○ |
| C-05 | URL一意制約（scope: release） | E-01 (14行目 uniqueness) | ○ |
| C-06 | name必須バリデーション | E-01 (15行目) | ○ |
| C-07 | name一意制約（scope: release） | E-01 (15行目 uniqueness) | ○ |
| C-08 | filepath一意制約（scope: release） | E-01 (16行目) | ○ |
| C-09 | filepath形式バリデーション | E-01 (11, 17, 21-26行目) | ○ |
| C-10 | FILEPATH_MAX_LENGTH = 128 | E-01 (12行目) | ○ |
| C-11 | link_type enum定義 | E-01 (30-35行目) | ○ |
| C-12 | link_type: other, runbook, package, image | E-01 (31-34行目) | ○ |
| C-13 | internal?メソッドによる内部/外部判定 | E-01 (37-39行目) | ○ |
| C-14 | 内部判定: url.start_with?(project.web_url) | E-01 (38行目) | ○ |
| C-15 | has_many :linksでリリースとの関連 | E-02 (17行目) | ○ |
| C-16 | accepts_nested_attributes_for :links | E-02 (26行目) | ○ |
| C-17 | allow_destroy: trueで削除サポート | E-02 (26行目) | ○ |
| C-18 | downloadsアクションでダウンロード処理 | E-03 (35-43行目) | ○ |
| C-19 | 内部URLは直接リダイレクト | E-03 (39行目) | ○ |
| C-20 | 外部URLはリダイレクトテンプレート表示 | E-03 (41行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 外部URLリダイレクト時の警告ページの内容確認
- [ ] ファイルパス形式のREGEXが意図通りか確認
