---
generated_at: 2026-01-22 13:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-リリースエビデンス機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/releases/evidence.rb`
- E-02: `app/services/releases/create_evidence_service.rb`
- E-03: `app/services/releases/create_service.rb`
- E-04: `app/controllers/projects/releases/evidences_controller.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | releaseへのbelongs_to関連 | E-01 (8行目) | ○ |
| C-02 | sha_attribute :summary_sha | E-01 (12行目) | ○ |
| C-03 | collected_atはcreated_atのエイリアス | E-01 (13行目) | ○ |
| C-04 | shaはsummary_shaのエイリアス | E-01 (14行目) | ○ |
| C-05 | summaryからissues情報を除外 | E-01 (25-33行目) | ○ |
| C-06 | コンストラクタでrelease, pipelineを受け取る | E-02 (5-8行目) | ○ |
| C-07 | EvidenceSerializerでサマリー収集 | E-02 (13行目) | ○ |
| C-08 | Gitlab::CryptoHelper.sha256でハッシュ計算 | E-02 (16行目) | ○ |
| C-09 | evidence.save!で保存 | E-02 (18行目) | ○ |
| C-10 | historical_release?でエビデンス生成スキップ | E-03 (108行目) | ○ |
| C-11 | upcoming_release?でエビデンス生成スキップ | E-03 (108行目) | ○ |
| C-12 | CreateEvidenceWorker.perform_asyncで非同期実行 | E-03 (110行目) | ○ |
| C-13 | authorize_read_release_evidence!で権限確認 | E-04 (8行目) | ○ |
| C-14 | showアクションでJSON形式で返却 | E-04 (13-17行目) | ○ |
| C-15 | evidence.summaryを返却 | E-04 (16行目) | ○ |
| C-16 | milestonesメソッドで関連マイルストーン取得 | E-01 (16-18行目) | ○ |
| C-17 | default_scopeで作成日時昇順 | E-01 (10行目) | ○ |
| C-18 | 関連画面No.87 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] EvidenceSerializerの詳細なJSON構造確認
- [ ] CreateEvidenceWorkerのリトライ設定確認
