---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：76-ユーザー登録機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 3秒以内という数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/registrations_controller.rb`
- E-02: `app/models/user.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Devise::RegistrationsControllerを継承 | E-01 (3行目) | ○ |
| C-02 | check_captchaでreCAPTCHA検証 | E-01 (20行目, 240-252行目) | ○ |
| C-03 | ensure_first_name_and_last_name_not_empty | E-01 (21行目, 254-264行目) | ○ |
| C-04 | レート制限チェック（user_sign_up） | E-01 (26行目) | ○ |
| C-05 | ensure_signup_enabledでサインアップ有効確認 | E-01 (29行目, 378-383行目) | ○ |
| C-06 | createアクションでユーザー作成 | E-01 (40-59行目) | ○ |
| C-07 | destroyアクションでアカウント削除 | E-01 (61-75行目) | ○ |
| C-08 | accept_pending_invitationsで招待受け入れ | E-01 (108行目) | ○ |
| C-09 | persist_accepted_terms_if_requiredで利用規約同意 | E-01 (79-84行目, 109行目) | ○ |
| C-10 | execute_system_hooksでシステムフック実行 | E-01 (110行目, 115-117行目) | ○ |
| C-11 | notify_new_instance_access_requestで承認待ち通知 | E-01 (111行目, 119-123行目) | ○ |
| C-12 | BLOCKED_PENDING_APPROVAL_STATE定数 | E-02 (53行目) | ○ |
| C-13 | set_resource_fieldsで承認待ち状態設定 | E-01 (313-317行目) | ○ |
| C-14 | set_blocked_pending_approval?でフラグ確認 | E-01 (319-321行目) | ○ |
| C-15 | Users::RegistrationsBuildServiceを使用 | E-01 (286-291行目) | ○ |
| C-16 | 削除時にsolo_owned_groupsを確認 | E-01 (219-225行目) | ○ |
| C-17 | delete_asyncで非同期削除 | E-01 (69行目) | ○ |
| C-18 | destroy_confirmation_valid?でパスワード/ユーザー名確認 | E-01 (86-92行目) | ○ |
| C-19 | skip_confirmation?で招待メール一致時スキップ | E-01 (297-305行目) | ○ |
| C-20 | organization_idを初期組織に設定 | E-01 (289行目, 385-389行目) | ○ |
| C-21 | preferred_languageを設定 | E-01 (288行目) | ○ |
| C-22 | 弱いパスワードエラートラッキング | E-01 (11行目, 374-376行目) | ○ |
| C-23 | Deviseのlockable, recoverableモジュール使用 | E-02 (119行目) | ○ |
| C-24 | 関連画面No.1, 4, 5, 200, 216 | E-03 | ○ |
| C-25 | パフォーマンス要件（3秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードからは確認できない。
  - 候補：非機能要件定義書 / SLA定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要と処理フロー（コードから明確に確認可能）
- 0: 低リスク - セキュリティ対策（reCAPTCHA、レート制限）
- 1: 中リスク - パフォーマンス要件（根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（3秒以内）が実運用要件と一致するか確認
- [ ] 身元確認（Identity Verification）のEE版機能の詳細確認
- [ ] Invisible CAPTCHAの動作確認
