---
generated_at: 2026-01-22 13:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：77-ユーザープロファイル機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/profiles_controller.rb`
- E-02: `app/models/user.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | authorize_change_username!でユーザー名変更可能確認 | E-01 (9行目, 68-70行目) | ○ |
| C-02 | profile_update_usernameレート制限 | E-01 (10-12行目) | ○ |
| C-03 | reset_incoming_email_tokenアクション | E-01 (17-23行目) | ○ |
| C-04 | reset_feed_tokenアクション | E-01 (25-35行目) | ○ |
| C-05 | reset_static_object_tokenアクション | E-01 (37-42行目) | ○ |
| C-06 | update_usernameアクション | E-01 (44-59行目) | ○ |
| C-07 | Users::UpdateServiceを使用 | E-01 (18, 38, 45行目) | ○ |
| C-08 | Users::ResetFeedTokenServiceを使用 | E-01 (26行目) | ○ |
| C-09 | user_params_attributesで許可属性定義 | E-01 (76-109行目) | ○ |
| C-10 | 許可属性にname, bio, job_title, location等 | E-01 (78-106行目) | ○ |
| C-11 | 許可属性にlinkedin, twitter, mastodon, bluesky | E-01 (81, 91, 93行目) | ○ |
| C-12 | 許可属性にdiscord, github | E-01 (83, 106行目) | ○ |
| C-13 | 許可属性にprivate_profile | E-01 (96行目) | ○ |
| C-14 | 許可属性にinclude_private_contributions | E-01 (89行目) | ○ |
| C-15 | ステータス設定（emoji, message, availability, clear_status_after） | E-01 (107行目) | ○ |
| C-16 | validation_passwordによる確認 | E-01 (104行目) | ○ |
| C-17 | MAX_USERNAME_LENGTH = 255 | E-02 (60行目) | ○ |
| C-18 | MAX_NAME_LENGTH = 127 | E-02 (62行目) | ○ |
| C-19 | 関連画面No.192, 202, 203, 215 | E-03 | ○ |
| C-20 | パフォーマンス要件（1-2秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードからは確認できない。
  - 候補：非機能要件定義書 / SLA定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要と処理フロー（コードから明確に確認可能）
- 0: 低リスク - 許可属性の定義（コードから明確）
- 1: 中リスク - パフォーマンス要件（根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件が実運用要件と一致するか確認
- [ ] ユーザー名変更時の影響範囲確認
- [ ] CarrierWaveによるアバター管理の詳細確認
