---
generated_at: 2026-01-22 13:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：79-2要素認証機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/profiles/two_factor_auths_controller.rb`
- E-02: `app/models/webauthn_registration.rb`
- E-03: `app/services/webauthn/register_service.rb`
- E-04: `app/services/two_factor/destroy_service.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ensure_verified_primary_emailでメール検証確認 | E-01 (5行目, 266-271行目) | ○ |
| C-02 | validate_current_passwordでパスワード確認 | E-01 (6-8行目, 154-171行目) | ○ |
| C-03 | update_current_user_otp!でOTPシークレット更新 | E-01 (9行目, 144-152行目) | ○ |
| C-04 | Users::ValidateManualOtpServiceでPIN検証 | E-01 (25-27行目) | ○ |
| C-05 | destroy_all_but_current_user_session!でセッション破棄 | E-01 (32, 36行目) | ○ |
| C-06 | otp_required_for_login = trueで2FA有効化 | E-01 (33, 38行目) | ○ |
| C-07 | generate_otp_backup_codes!でバックアップコード生成 | E-01 (39, 75, 93行目) | ○ |
| C-08 | Webauthn::RegisterServiceでWebAuthn登録 | E-01 (56-60行目), E-03 | ○ |
| C-09 | WebAuthn::Credential.from_createで認証レスポンス検証 | E-03 (17行目) | ○ |
| C-10 | webauthn_credential.verifyでチャレンジ検証 | E-03 (18行目) | ○ |
| C-11 | credential_xid, public_key, counterをWebauthnRegistrationに保存 | E-03 (20-28行目), E-02 (8行目) | ○ |
| C-12 | TwoFactor::DestroyServiceで2FA無効化 | E-01 (100行目), E-04 | ○ |
| C-13 | can?(:disable_two_factor, user)で権限確認 | E-04 (18-19行目) | ○ |
| C-14 | user.disable_two_factor!で2FA無効化実行 | E-04 (22-25行目) | ○ |
| C-15 | notification_service.disabled_two_factorで通知送信 | E-04 (28-29行目) | ○ |
| C-16 | build_qr_codeでQRコード生成 | E-01 (173-187行目) | ○ |
| C-17 | RQRCode::QRCode.newでQRコード生成 | E-01 (175-178行目) | ○ |
| C-18 | setup_webauthn_registrationでWebAuthn設定準備 | E-01 (201-212行目) | ○ |
| C-19 | WebAuthn::Credential.options_for_createでオプション生成 | E-01 (236-249行目) | ○ |
| C-20 | authentication_modeはpasswordlessとsecond_factor | E-02 (14-17行目) | ○ |
| C-21 | skipアクションで猶予期間中はスキップ可能 | E-01 (133-140行目) | ○ |
| C-22 | パフォーマンス要件（QRコード生成1秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードからは確認できない。
  - 候補：非機能要件定義書 / SLA定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要と処理フロー（コードから明確に確認可能）
- 0: 低リスク - 2FA有効化・無効化処理（コードから明確）
- 0: 低リスク - WebAuthn登録処理（コードから明確）
- 1: 中リスク - パフォーマンス要件（根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件が実運用要件と一致するか確認
- [ ] WebAuthnの認証モード（passwordless/second_factor）の使い分け確認
- [ ] EE版追加セキュリティ機能の詳細確認
