---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-プロジェクト統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/project_statistics.rb` - COLUMNS_TO_REFRESH定義（23行目）
- E-02: `app/models/project_statistics.rb` - STORAGE_SIZE_COMPONENTS定義（29-37行目）
- E-03: `app/models/project_statistics.rb` - refresh!メソッド（47-60行目）
- E-04: `app/models/project_statistics.rb` - update_repository_size（66-68行目）
- E-05: `app/models/project_statistics.rb` - update_wiki_size（70-72行目）
- E-06: `app/models/project_statistics.rb` - update_lfs_objects_size（78-80行目）
- E-07: `app/models/project_statistics.rb` - update_commit_count（62-64行目）
- E-08: `app/models/project_statistics.rb` - update_snippets_size（74-76行目）
- E-09: `app/models/project_statistics.rb` - update_uploads_size（82-84行目）
- E-10: `app/models/project_statistics.rb` - update_container_registry_size（86-88行目）
- E-11: `app/models/project_statistics.rb` - refresh_storage_size!（107-109行目）
- E-12: `app/models/project_statistics.rb` - counter_attribute定義（12-13行目）
- E-13: `app/models/project_statistics.rb` - increment_statistic（115-121, 131-135行目）
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.8の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | COLUMNS_TO_REFRESHで更新対象カラムが定義されている | E-01 | ○ |
| C-02 | STORAGE_SIZE_COMPONENTSでストレージ構成要素が定義されている | E-02 | ○ |
| C-03 | refresh!で読み取り専用DBチェックがある | E-03 (48行目) | ○ |
| C-04 | refresh!でonlyパラメータによる部分更新が可能 | E-03 (50行目) | ○ |
| C-05 | update_repository_sizeでリポジトリサイズが計算される | E-04 | ○ |
| C-06 | update_wiki_sizeでWikiサイズが計算される | E-05 | ○ |
| C-07 | update_lfs_objects_sizeでLFSサイズが計算される | E-06 | ○ |
| C-08 | update_commit_countでコミット数が計算される | E-07 | ○ |
| C-09 | update_snippets_sizeでスニペットサイズが計算される | E-08 | ○ |
| C-10 | update_uploads_sizeでアップロードサイズが計算される | E-09 | ○ |
| C-11 | update_container_registry_sizeでCRサイズが計算される | E-10 | ○ |
| C-12 | refresh_storage_size!でストレージサイズが再計算される | E-11 | ○ |
| C-13 | build_artifacts_sizeとpackages_sizeはcounter_attribute | E-12 | ○ |
| C-14 | increment_statisticで差分更新が可能 | E-13 | ○ |
| C-15 | 名前空間集計が非同期でスケジュールされる | E-03 (55-57行目), `app/models/project_statistics.rb` (162-166行目) | ○ |
| C-16 | pending_deleteのプロジェクトは統計更新しない | E-13 (116行目) | ○ |
| C-17 | counter_attribute_after_commitで名前空間集計が呼ばれる | `app/models/project_statistics.rb` (15-19行目) | ○ |
| C-18 | 機能No.8がプロジェクト統計機能 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が十分に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 各サイズ計算の単位（バイト/メガバイト）が設計書で正確に記載されているか確認
- [ ] カウンター属性のRedisバッファリング仕様について詳細が必要か検討
- [ ] 大規模リポジトリでのパフォーマンス懸念について文書化されているか確認
