---
generated_at: 2026-01-22 13:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：80-SSHキー管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的な数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/user_settings/ssh_keys_controller.rb`
- E-02: `app/models/key.rb`
- E-03: `app/services/keys/create_service.rb`
- E-04: `app/services/keys/destroy_service.rb`
- E-05: `app/services/keys/revoke_service.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | indexアクションでkeys.order_id_desc | E-01 (9行目) | ○ |
| C-02 | showアクションでkeys.find | E-01 (14行目) | ○ |
| C-03 | createでKeys::CreateService使用 | E-01 (19-20行目) | ○ |
| C-04 | destroyでKeys::DestroyService使用 | E-01 (32行目) | ○ |
| C-05 | revokeでKeys::RevokeService使用 | E-01 (42行目) | ○ |
| C-06 | key_paramsでtitle, key, usage_type, expires_at許可 | E-01 (53行目) | ○ |
| C-07 | titleバリデーション最大255文字 | E-02 (28-30行目) | ○ |
| C-08 | keyバリデーション最大5000文字 | E-02 (32-36行目) | ○ |
| C-09 | fingerprint_sha256一意性バリデーション | E-02 (38-40行目) | ○ |
| C-10 | expirationバリデーション | E-02 (42行目, 202-204行目) | ○ |
| C-11 | banned_keyバリデーション | E-02 (43行目, 187-200行目) | ○ |
| C-12 | usage_type列挙型定義 | E-02 (47-52行目) | ○ |
| C-13 | post_create_hookでSystemHooksService.execute_hooks_for | E-02 (54行目, 124-127行目) | ○ |
| C-14 | refresh_user_cacheでUsers::KeysCountService | E-02 (55, 136-140行目) | ○ |
| C-15 | add_to_authorized_keysでAuthorizedKeysWorker | E-02 (58行目, 117-121行目) | ○ |
| C-16 | generate_fingerprintでSHA256計算 | E-02 (26行目, 177-185行目) | ○ |
| C-17 | FIPSモードでMD5非生成 | E-02 (183行目) | ○ |
| C-18 | CreateServiceでuser.keys.create | E-03 (16行目) | ○ |
| C-19 | CreateServiceでnotification_service.new_key | E-03 (17行目) | ○ |
| C-20 | DestroyServiceでkey.destroy | E-04 (18-19行目) | ○ |
| C-21 | RevokeServiceでunverify_associated_signatures | E-05 (7行目, 15-21行目) | ○ |
| C-22 | ssh_signaturesをrevoked_keyに更新 | E-05 (17-18行目) | ○ |
| C-23 | RevokeServiceはDestroyServiceを継承 | E-05 (4行目) | ○ |
| C-24 | パフォーマンス要件（キー登録2秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードからは確認できない。
  - 候補：非機能要件定義書 / SLA定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能概要と処理フロー（コードから明確に確認可能）
- 0: 低リスク - バリデーションルール（コードから明確）
- 0: 低リスク - サービス層の処理（コードから明確）
- 1: 中リスク - パフォーマンス要件（根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件が実運用要件と一致するか確認
- [ ] 禁止キーリストの管理方法確認
- [ ] authorized_keysの同期タイミング確認
- [ ] EE版追加制限機能の詳細確認
