---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：81-個人アクセストークン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **DPoP対応オプション**：フィーチャーフラグ名の確認が必要
  2. **監査ログ記録詳細**：監査イベントの具体的な実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/models/personal_access_token.rb`
- E-02: `app/services/personal_access_tokens/create_service.rb`
- E-03: `app/services/personal_access_tokens/revoke_service.rb`
- E-04: `app/services/personal_access_tokens/rotate_service.rb`
- E-05: `app/controllers/user_settings/personal_access_tokens_controller.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トークンはglpat-プレフィックスで始まる | E-01 (22行目 PERSONAL_TOKEN_PREFIX) | ○ |
| C-02 | スコープはシリアライズされた配列として保存 | E-01 (41行目 serialize :scopes) | ○ |
| C-03 | 最大有効期限は365日または400日 | E-01 (38-39行目 MAX_*) | ○ |
| C-04 | トークン作成時に通知が送信される | E-02 (26行目 NotificationService) | ○ |
| C-05 | 作成権限はAbility.allowed?で確認 | E-02 (67行目 creation_permitted?) | ○ |
| C-06 | 取り消し時にrevoked=trueに更新 | E-01 (108行目 update_columns) | ○ |
| C-07 | ローテーションはトランザクション内で実行 | E-04 (22行目 PersonalAccessToken.transaction) | ○ |
| C-08 | ICSフィード機能が存在 | E-05 (33-43行目 format.ics) | ○ |
| C-09 | トークン有効期限の通知間隔定義 | E-01 (16-20行目 NOTIFICATION_INTERVALS) | ○ |
| C-10 | ユーザー、グループ、組織に関連付け | E-01 (45-48行目 belongs_to) | ○ |
| C-11 | スコープバリデーションが実装されている | E-01 (195-199行目 validate_scopes) | ○ |
| C-12 | 有効期限バリデーションが実装されている | E-01 (221-233行目 expires_at_before_instance_max_expiry_date) | ○ |
| C-13 | 取り消しソースはVALID_SOURCESで制限 | E-03 (7行目 VALID_SOURCES) | ○ |
| C-14 | ローテーション時のデフォルト有効期間は1週間 | E-04 (7行目 EXPIRATION_PERIOD = 1.week) | ○ |
| C-15 | keep_token_lifetimeオプションが存在 | E-04 (93-98行目) | ○ |
| C-16 | project_botユーザーのメンバーシップ更新 | E-04 (73-83行目 update_project_bot_membership) | ○ |
| C-17 | 画面機能マッピングでNo.81が定義されている | E-06 | ○ |
| C-18 | 機能一覧でNo.81が個人アクセストークンとして定義 | E-07 | ○ |
| C-19 | Granular PAT機能がフィーチャーフラグで制御 | E-05 (47行目 Feature.enabled?(:granular_personal_access_tokens)) | ○ |
| C-20 | トークン作成イベントがトラッキングされる | E-02 (74-85行目 track_event) | ○ |
| C-21 | インスタンス設定でトークン無効化可能 | E-05 (110-112行目 personal_access_tokens_disabled?) | ○ |
| C-22 | ソート機能が複数パターンで提供 | E-01 (119-131行目 simple_sorts) | ○ |
| C-23 | トークン検索機能が実装されている | E-01 (144-146行目 search) | ○ |
| C-24 | DPoP対応オプションが存在 | E-05 (66-81行目 toggle_dpop) | △ |
| C-25 | 監査ログにトークン操作が記録される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24（DPoP対応）：フィーチャーフラグ`dpop_authentication`の有効化条件と実装詳細の確認が必要
  - 候補：`config/feature_flags/` / EEコード / ドキュメント
- C-25（監査ログ）：監査イベント記録の具体的な実装箇所の確認が必要
  - 候補：`AuditEventService` / `Gitlab::Audit::Auditor` / EEコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD操作とサービス層の実装は確認済み
- 1: 中リスク - EE機能（監査ログ、DPoP）の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] トークンプレフィックスのカスタマイズ設定が正しく記載されているか確認
- [ ] 有効期限計算ロジックの境界値が正確か確認
- [ ] スコープ一覧の網羅性を確認（api, read_api, read_user等）
- [ ] EE機能（監査ログ、DPoP）の記載が環境に適合しているか確認
- [ ] 通知設定（メール送信条件）の詳細を確認
