---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：82-メール管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **レートリミット設定値**：具体的な制限値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/models/email.rb`
- E-02: `app/services/emails/create_service.rb`
- E-03: `app/services/emails/destroy_service.rb`
- E-04: `app/services/emails/confirm_service.rb`
- E-05: `app/controllers/profiles/emails_controller.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザーは複数のメールアドレスを登録可能 | E-01 (12行目 belongs_to :user) | ○ |
| C-02 | メールアドレスは一意性バリデーション | E-01 (15行目 uniqueness: true) | ○ |
| C-03 | メールアドレスは小文字に正規化 | E-01 (43-45行目 downcase.strip) | ○ |
| C-04 | detumbled_emailで正規化処理 | E-01 (66-68行目 detumble_email!) | ○ |
| C-05 | プライマリメールは削除不可 | E-03 (6行目 raise StandardError) | ○ |
| C-06 | Deviseのconfirmableモジュール使用 | E-01 (32行目 devise :confirmable) | ○ |
| C-07 | 非同期メール送信対応 | E-01 (36行目 AsyncDeviseEmail) | ○ |
| C-08 | 管理者はskip_confirmationオプション使用可能 | E-02 (9行目 if skip_confirmation && current_user.admin?) | ○ |
| C-09 | メール追加時に通知送信 | E-02 (10行目 notification_service.new_email_address_added) | ○ |
| C-10 | 削除時に通知設定リセット | E-03 (10行目 reset_email_in_notification_settings!) | ○ |
| C-11 | 削除時にセカンダリメール更新 | E-03 (11行目 update_secondary_emails!) | ○ |
| C-12 | 確認メール再送機能 | E-04 (6行目 resend_confirmation_instructions) | ○ |
| C-13 | GPG署名検証は確認後に更新 | E-01 (30行目, 52-54行目) | ○ |
| C-14 | confirmed/unconfirmedスコープ | E-01 (25-27行目) | ○ |
| C-15 | 画面No.208でメール管理が定義 | E-06 | ○ |
| C-16 | 機能一覧No.82がメール管理として定義 | E-07 | ○ |
| C-17 | レートリミットによるスパム防止 | E-05 (7-10行目 check_rate_limit!) | ○ |
| C-18 | 具体的なレートリミット値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18（レートリミット値）：具体的なレート制限値（回数/時間）の確認が必要
  - 候補：`config/` / `lib/gitlab/application_rate_limiter.rb` / 設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD操作は確認済み
- 0: 低リスク - Deviseによるメール確認機能は標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] レートリミットの具体的な設定値を確認
- [ ] メール正規化ロジック（detumble）の仕様を確認
- [ ] GPG署名更新の影響範囲を確認
- [ ] セカンダリメール削除時の影響範囲を確認
