---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：83-通知設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/models/notification_setting.rb`
- E-02: `app/controllers/profiles/notifications_controller.rb`
- E-03: `app/services/notification_recipients/build_service.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知レベルはenumで定義（0-5） | E-01 (7行目 enum :level) | ○ |
| C-02 | グローバル、グループ、プロジェクト単位で設定可能 | E-01 (10行目 polymorphic), E-02 (9-11行目) | ○ |
| C-03 | EMAIL_EVENTSでカスタマイズ可能イベント定義 | E-01 (38-58行目) | ○ |
| C-04 | EXCLUDED_WATCHER_EVENTSでwatch除外イベント定義 | E-01 (60-66行目) | ○ |
| C-05 | 通知先メールは確認済みのみ | E-01 (124-129行目 notification_email_verified) | ○ |
| C-06 | ユーザーとソースで一意性制約 | E-01 (15-17行目 uniqueness) | ○ |
| C-07 | failed_pipelineはnullでtrue扱い | E-01 (102-107行目) | ○ |
| C-08 | fixed_pipelineはnullでtrue扱い | E-01 (109-114行目) | ○ |
| C-09 | reset_email_for_user!でメールリセット | E-01 (90-97行目) | ○ |
| C-10 | for_groupsスコープでグループ設定取得 | E-01 (20行目) | ○ |
| C-11 | for_projectsスコープでプロジェクト設定取得 | E-01 (25-30行目) | ○ |
| C-12 | showアクションで設定表示 | E-02 (7-13行目) | ○ |
| C-13 | updateアクションで設定更新 | E-02 (15-25行目) | ○ |
| C-14 | グループ設定はUserGroupNotificationSettingsFinder経由 | E-02 (10行目) | ○ |
| C-15 | プロジェクト設定はpreload付きで取得 | E-02 (37-52行目) | ○ |
| C-16 | 更新はUsers::UpdateService経由 | E-02 (16行目) | ○ |
| C-17 | new_releaseイベントが定義されている | E-01 (39行目) | ○ |
| C-18 | merge_when_pipeline_succeedsイベントが定義 | E-01 (57行目) | ○ |
| C-19 | 画面No.204で通知設定が定義 | E-04 | ○ |
| C-20 | 機能一覧No.83が通知設定として定義 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] EMAIL_EVENTSの全イベントが設計書に記載されているか確認
- [ ] 通知レベルの継承ルール（グローバル→グループ→プロジェクト）の動作確認
- [ ] EE機能（追加イベント等）の有無を確認
