---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-プロジェクトメンバー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/models/member.rb`
- E-02: `app/controllers/projects/project_members_controller.rb`
- E-03: `app/services/members/create_service.rb`
- E-04: `app/services/members/destroy_service.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メンバーはuser, source（polymorphic）に関連付く | E-01 (30-33行目) | ○ |
| C-02 | invite?, request?, pending?メソッドで状態判定 | E-01 (532-542行目) | ○ |
| C-03 | activeスコープで有効なメンバーを取得 | E-01 (132-143行目) | ○ |
| C-04 | authorize_admin_project_member!で権限チェック | E-02 (10行目) | ○ |
| C-05 | DEFAULT_INVITE_LIMITは100 | E-03 (10行目) | ○ |
| C-06 | BlankInvitesError, TooManyInvitesErrorが定義 | E-03 (5-6行目) | ○ |
| C-07 | CreatorServiceでメンバー作成 | E-03 (106-108行目) | ○ |
| C-08 | MembersAddedEventが発行される | E-03 (195-205行目) | ○ |
| C-09 | 削除時にdelete_subresourcesが呼ばれる | E-04 (122-128行目) | ○ |
| C-10 | 削除時にTodo削除がエンキューされる | E-04 (61行目) | ○ |
| C-11 | Owner権限付与はmanage_owners権限が必要 | E-03 (57-59行目) | ○ |
| C-12 | expires_atは未来日付のみバリデーション | E-01 (37行目 future_date: true) | ○ |
| C-13 | 招待トークンはDevise.token_generatorで生成 | E-01 (586-590行目) | ○ |
| C-14 | 招待メールはsend_inviteで送信 | E-01 (704-706行目) | ○ |
| C-15 | システムフックが実行される | E-01 (738, 750, 762, 766, 770行目) | ○ |
| C-16 | higher_access_level_than_groupバリデーション | E-01 (840-846行目) | ○ |
| C-17 | MembershipActionsコンサーンを使用 | E-02 (4行目 include MembershipActions) | ○ |
| C-18 | 画面No.124でメンバー一覧が定義 | E-05 | ○ |
| C-19 | 機能一覧No.84がプロジェクトメンバー管理として定義 | E-06 | ○ |
| C-20 | ACCESS_REQUEST_APPROVERS_TO_BE_NOTIFIED_LIMITは10 | E-01 (23行目) | ○ |
| C-21 | DestroyedEventが発行される | E-04 (229-242行目) | ○ |
| C-22 | グループオーナー削除時はロックを使用 | E-04 (75-81行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] アクセスレベルの定義値（10, 15, 20, 30, 40, 50）が正確か確認
- [ ] グループメンバーシップとの継承関係の動作確認
- [ ] EE機能（LDAP同期等）の有無を確認
