---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-グループメンバー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups/group_members_controller.rb`
- E-02: `app/services/members/destroy_service.rb`
- E-03: `app/models/member.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MEMBER_PER_PAGE_LIMIT = 50 | E-01 (10行目) | ○ |
| C-02 | indexアクションでGroupMembersFinder使用 | E-01 (55-58行目) | ○ |
| C-03 | 管理者のみ招待メンバー取得 | E-01 (31-39行目) | ○ |
| C-04 | アクセスリクエストをAccessRequestsFinderで取得 | E-01 (44-46行目) | ○ |
| C-05 | 2FAフィルタリングが可能 | E-01 (81行目 two_factor) | ○ |
| C-06 | ユーザータイプフィルタリングが可能 | E-01 (81行目 user_type) | ○ |
| C-07 | 最後のOwner削除時はロックを取得 | E-02 (75-81行目) | ○ |
| C-08 | last_owner?チェックが行われる | E-02 (77行目) | ○ |
| C-09 | delete_project_membersでプロジェクトメンバー削除 | E-02 (130-134行目) | ○ |
| C-10 | delete_subgroup_membersでサブグループメンバー削除 | E-02 (136-139行目) | ○ |
| C-11 | delete_invited_membersで招待メンバー削除 | E-02 (142-148行目) | ○ |
| C-12 | a_group_owner?でオーナー判定 | E-02 (96-98行目) | ○ |
| C-13 | placeholder_users_countを返却 | E-01 (42, 108-116行目) | ○ |
| C-14 | MembershipActionsコンサーン使用 | E-01 (4行目) | ○ |
| C-15 | 画面No.144でグループメンバー一覧定義 | E-04 | ○ |
| C-16 | 機能一覧No.85がグループメンバー管理として定義 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] サブグループ・プロジェクトへのメンバーシップ継承動作の確認
- [ ] 最後のOwner保護ロジックの動作確認
- [ ] LDAP同期（EE機能）との連携確認
