---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-招待機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/member.rb`
- E-02: `app/services/members/invite_service.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InviteServiceはCreateServiceを継承 | E-02 (4行目) | ○ |
| C-02 | メールアドレスはカンマ区切りでパース | E-02 (22-24行目) | ○ |
| C-03 | 無効なメールアドレスは除外 | E-02 (39-46行目) | ○ |
| C-04 | invite?メソッドでinvite状態を判定 | E-01 (532-534行目) | ○ |
| C-05 | accept_invite!で招待承諾 | E-01 (559-574行目) | ○ |
| C-06 | decline_invite!で招待辞退 | E-01 (576-584行目) | ○ |
| C-07 | generate_invite_tokenでトークン生成 | E-01 (586-590行目) | ○ |
| C-08 | Devise.token_generatorを使用 | E-01 (587行目) | ○ |
| C-09 | resend_inviteで再送可能 | E-01 (596-602行目) | ○ |
| C-10 | send_inviteがafter_createで呼ばれる | E-01 (364行目) | ○ |
| C-11 | 招待メールはMembers::InviteMailerで送信 | E-01 (704-706行目) | ○ |
| C-12 | 承諾時にinvite_tokenがnullになる | E-01 (566行目) | ○ |
| C-13 | 承諾時にinvite_accepted_atが設定される | E-01 (567行目) | ○ |
| C-14 | after_accept_inviteで後処理 | E-01 (795-801行目) | ○ |
| C-15 | InviteAcceptedMailerで承諾通知 | E-01 (796行目) | ○ |
| C-16 | InviteDeclinedMailerで辞退通知 | E-01 (804行目) | ○ |
| C-17 | 画面No.305, 306で招待確認/辞退が定義 | E-03 | ○ |
| C-18 | 機能一覧No.86が招待機能として定義 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 招待トークンの有効期限設定の確認
- [ ] サインアップ制限との連携動作の確認
- [ ] リマインダーメール機能の詳細確認
