---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-アクセスリクエスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/member.rb`
- E-02: `app/services/members/request_access_service.rb`
- E-03: `app/services/members/approve_access_request_service.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ACCESS_REQUEST_APPROVERS_TO_BE_NOTIFIED_LIMIT = 10 | E-01 (23行目) | ○ |
| C-02 | request?メソッドでリクエスト状態判定 | E-01 (536-538行目) | ○ |
| C-03 | accept_requestで承認処理 | E-01 (550-557行目) | ○ |
| C-04 | send_requestで管理者通知 | E-01 (708-716行目) | ○ |
| C-05 | デフォルト権限はDEVELOPER | E-02 (17-19行目) | ○ |
| C-06 | can_request_access?で権限チェック | E-02 (22-24行目) | ○ |
| C-07 | requested_at設定でリクエスト作成 | E-02 (10-13行目) | ○ |
| C-08 | 承認時にaccess_level変更可能 | E-03 (10行目) | ○ |
| C-09 | handle_request_acceptanceで承認処理 | E-03 (21-24行目) | ○ |
| C-10 | can_approve_access_requester?で承認権限チェック | E-03 (40-43行目) | ○ |
| C-11 | admin_member_access_request権限が必要 | E-03 (41行目) | ○ |
| C-12 | resolve_access_request_todosでTodo解決 | E-03 (29行目) | ○ |
| C-13 | request/non_requestスコープ | E-01 (193-194行目) | ○ |
| C-14 | TodoService#create_member_access_request_todos | E-01 (715行目) | ○ |
| C-15 | 機能一覧No.87がアクセスリクエストとして定義 | E-05 | ○ |
| C-16 | request_accepted_atが承認時に設定される | E-01 (553行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] プライベートプロジェクト/グループでのリクエスト可否の動作確認
- [ ] 承認者への通知制限（10人）の動作確認
- [ ] Todo作成・解決の動作確認
