---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-OAuth2プロバイダ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/oauth/authorizations_controller.rb`
- E-02: `app/controllers/oauth/applications_controller.rb`
- E-03: `app/models/authn/oauth_application.rb`
- E-04: `app/models/oauth_access_token.rb`
- E-05: `app/services/applications/create_service.rb`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Doorkeeper::AuthorizationsControllerを継承 | E-01 (3行目) | ○ |
| C-02 | verify_confirmed_email!でメール確認 | E-01 (14行目, 143-148行目) | ○ |
| C-03 | validate_pkce_for_dynamic_applicationsでPKCE検証 | E-01 (16行目, 167-180行目) | ○ |
| C-04 | audit_oauth_authorizationで監査ログ記録 | E-01 (17行目, 44-62行目) | ○ |
| C-05 | pre_auth.authorizable?で認可可能性判定 | E-01 (25行目) | ○ |
| C-06 | matching_token?とconfidential?で自動承認判定 | E-01 (26行目) | ○ |
| C-07 | downgrade_scopes!でスコープダウングレード | E-01 (103-110行目) | ○ |
| C-08 | disallow_connect?で管理者制限判定 | E-01 (154-157行目) | ○ |
| C-09 | dangerous_scopes?でAPI/ADMIN等スコープ判定 | E-01 (159-165行目) | ○ |
| C-10 | PKCEはS256メソッドのみ許可 | E-01 (176行目) | ○ |
| C-11 | Doorkeeper::ApplicationsControllerを継承 | E-02 (3行目) | ○ |
| C-12 | Applications::CreateServiceでアプリ作成 | E-02 (31行目) | ○ |
| C-13 | renew_secretでシークレット更新 | E-02 (44-54行目) | ○ |
| C-14 | OauthApplicationはDoorkeeper::Applicationを継承 | E-03 (4行目) | ○ |
| C-15 | secret_matches?でフォールバック対応 | E-03 (17-31行目) | ○ |
| C-16 | RETENTION_PERIOD = 1.month | E-04 (18行目) | ○ |
| C-17 | expires_inは必須バリデーション | E-04 (10行目) | ○ |
| C-18 | スコープ必須チェック | E-05 (27-31行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Doorkeeper設定（config/initializers/doorkeeper.rb）との整合性確認
- [ ] MCP（Model Context Protocol）連携の動作確認
- [ ] 管理者スコープ制限（disable_admin_oauth_scopes）の動作確認
