---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-OAuth2クライアント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/omniauth_callbacks_controller.rb`
- E-02: `lib/gitlab/auth/o_auth/user.rb`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Devise::OmniauthCallbacksControllerを継承 | E-01 (3行目) | ○ |
| C-02 | INVALID_FRAGMENT_EXP = %r{[;/?:@&=+$,]+} | E-01 (21行目) | ○ |
| C-03 | protect_from_forgeryでSAMLを例外設定 | E-01 (27行目) | ○ |
| C-04 | handle_omniauthでSAML/OIDC/OAuth分岐 | E-01 (34-42行目) | ○ |
| C-05 | プロバイダ毎のエイリアスメソッド動的定義 | E-01 (44-46行目) | ○ |
| C-06 | failureでfailed_attempts増加 | E-01 (62-75行目) | ○ |
| C-07 | omniauth_flowがメイン認証フロー | E-01 (154-198行目) | ○ |
| C-08 | admin_mode_request?で管理者モード判定 | E-01 (200-202行目) | ○ |
| C-09 | sign_in_user_flowでサインイン処理 | E-01 (244-294行目) | ○ |
| C-10 | log_audit_eventで監査ログ記録 | E-01 (390-408行目) | ○ |
| C-11 | set_remember_meでログイン保持設定 | E-01 (410-418行目) | ○ |
| C-12 | store_idp_two_factor_statusで2FAバイパス保存 | E-01 (515-517行目) | ○ |
| C-13 | find_by_uid_and_providerでユーザー検索 | E-02 (15-24行目) | ○ |
| C-14 | SignupDisabledError定義 | E-02 (26行目) | ○ |
| C-15 | SigninDisabledForProviderError定義 | E-02 (27行目) | ○ |
| C-16 | IdentityWithUntrustedExternUidError定義 | E-02 (28行目) | ○ |
| C-17 | find_userで検索優先順位（uid/email/ldap/新規） | E-02 (82-92行目) | ○ |
| C-18 | bypass_two_factor?で2FAバイパス判定 | E-02 (100-107行目) | ○ |
| C-19 | add_or_update_user_identitiesでアイデンティティ更新 | E-02 (125-138行目) | ○ |
| C-20 | auto_link_ldap_user?でLDAP自動リンク判定 | E-02 (161-163行目) | ○ |
| C-21 | signup_enabled?でサインアップ可否判定 | E-02 (198-205行目) | ○ |
| C-22 | oauth_provider_disabled?でプロバイダ無効判定 | E-02 (300-304行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各プロバイダ（Google、GitHub等）の設定確認
- [ ] auto_link_user設定の動作確認
- [ ] SAML認証フローの特別処理確認
- [ ] 二要素認証バイパス設定の確認
