---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-グループ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups_controller.rb` - createアクション（83-109行目）
- E-02: `app/controllers/groups_controller.rb` - authorize_create_group!（316-327行目）
- E-03: `app/services/groups/create_service.rb` - executeメソッド（11-27行目）
- E-04: `app/services/groups/create_service.rb` - build_group（48-62行目）
- E-05: `app/services/groups/create_service.rb` - create_group（64-76行目）
- E-06: `app/services/groups/create_service.rb` - valid_user_permissions?（101-124行目）
- E-07: `app/services/groups/create_service.rb` - inherit_group_shared_runners_settings（182-187行目）
- E-08: `app/services/groups/create_service.rb` - set_visibility_level（170-174行目）
- E-09: `app/services/groups/create_service.rb` - set_organization（189-195行目）
- E-10: `app/services/groups/create_service.rb` - set_jwt_ci_cd_job_token_enabled（176-180行目）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.9の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createアクションがCreateServiceを呼び出す | E-01 (84-87行目) | ○ |
| C-02 | サブグループ権限チェックがある | E-02 (318-321行目) | ○ |
| C-03 | トップレベルグループ権限チェックがある | E-02 (322-323行目) | ○ |
| C-04 | executeでbuild_groupが呼ばれる | E-03 (12行目) | ○ |
| C-05 | executeでvalid?チェックがある | E-03 (15行目) | ○ |
| C-06 | nameが未指定の場合pathから設定される | E-03 (17行目) | ○ |
| C-07 | create_chat_teamが呼ばれる | E-03 (19行目) | ○ |
| C-08 | create_groupが呼ばれる | E-03 (20行目) | ○ |
| C-09 | build_groupで不許可パラメータが削除される | E-04 (49行目) | ○ |
| C-10 | build_groupで可視性レベルが設定される | E-04 (51行目) | ○ |
| C-11 | build_groupで組織が設定される | E-04 (56行目) | ○ |
| C-12 | create_groupがトランザクション内で実行される | E-05 (68行目) | ○ |
| C-13 | オーナーが追加される | E-05 (70行目) | ○ |
| C-14 | 作成者が追加される | E-05 (71行目) | ○ |
| C-15 | デフォルトインテグレーションが作成される | E-05 (72行目) | ○ |
| C-16 | valid_user_permissions?でサブグループ権限検証 | E-06 (102-108行目) | ○ |
| C-17 | valid_user_permissions?でトップレベル権限検証 | E-06 (109-115行目) | ○ |
| C-18 | 親グループから共有ランナー設定が継承される | E-07 | ○ |
| C-19 | 可視性レベルのデフォルト値が設定される | E-08 | ○ |
| C-20 | トップレベルグループでjwt_ci_cd_job_token_enabledがtrueになる | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が十分に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 組織設定の検証ロジック（organization_setting_valid?）の詳細が必要か検討
- [ ] Mattermostチーム連携の前提条件について文書化されているか確認
- [ ] default_branch_protection設定の権限について詳細が必要か検討
