---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-LDAP認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `lib/gitlab/auth/ldap/config.rb`
- E-02: `lib/gitlab/auth/ldap/authentication.rb`
- E-03: `lib/gitlab/auth/ldap/access.rb`
- E-04: `lib/gitlab/auth/ldap/user.rb`
- E-05: `app/controllers/ldap/omniauth_callbacks_controller.rb`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NET_LDAP_ENCRYPTION_METHOD定義（simple_tls, start_tls, plain） | E-01 (8-12行目) | ○ |
| C-02 | enabled?でLDAP有効判定 | E-01 (18-20行目) | ○ |
| C-03 | sign_in_enabled?でサインイン可否判定 | E-01 (22-24行目) | ○ |
| C-04 | prevent_ldap_sign_in?でサインイン制限判定 | E-01 (26-28行目) | ○ |
| C-05 | serversでサーバー一覧取得 | E-01 (30-32行目) | ○ |
| C-06 | adapter_optionsでNet::LDAP接続オプション生成 | E-01 (83-92行目) | ○ |
| C-07 | omniauth_optionsでOmniAuthオプション生成 | E-01 (94-112行目) | ○ |
| C-08 | default_attributesでuid/email/name属性マッピング | E-01 (215-223行目) | ○ |
| C-09 | Gitlab::Auth::OAuth::Authenticationを継承 | E-02 (12行目) | ○ |
| C-10 | self.loginで複数プロバイダ順次試行 | E-02 (13-22行目) | ○ |
| C-11 | adapter.bind_asでLDAP認証 | E-02 (29-34行目) | ○ |
| C-12 | user_filterでNet::LDAP::Filter構築 | E-02 (47-69行目) | ○ |
| C-13 | self.allowed?で許可判定と更新実行 | E-03 (19-34行目) | ○ |
| C-14 | 非AD時は存在確認のみで許可 | E-03 (45-48行目) | ○ |
| C-15 | disabled_via_active_directory?でAD無効化チェック | E-03 (51行目) | ○ |
| C-16 | block_userでユーザーブロック | E-03 (91-105行目) | ○ |
| C-17 | unblock_userでactivate | E-03 (107-114行目) | ○ |
| C-18 | LDAP非存在時はblock_user実行 | E-03 (59-61行目) | ○ |
| C-19 | Gitlab::Auth::OAuth::Userを継承 | E-04 (12行目) | ○ |
| C-20 | valid_sign_in?でsuper + allowed?実行 | E-04 (33-39行目) | ○ |
| C-21 | block_after_signup?でldap_config.block_auto_created_users参照 | E-04 (25-27行目) | ○ |
| C-22 | OmniauthCallbacksControllerを継承 | E-05 (3行目) | ○ |
| C-23 | define_providers!でプロバイダエイリアス定義 | E-05 (8-14行目) | ○ |
| C-24 | log_audit_eventで'authenticated_with_ldap'記録 | E-05 (54-57行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] LDAPサーバー接続設定の確認
- [ ] Active Directory互換モードの動作確認
- [ ] 自動ブロック/アンブロック機能の動作確認
- [ ] グループ同期（EE機能）の確認
- [ ] TLS/SSL設定と証明書検証の確認
