---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：91-JWT認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **レスポンス時間要件**：具体的な数値の根拠不足
  2. **スループット要件**：具体的な数値の根拠不足
  3. **ルーティング設定**：routes.rbでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/jwt_controller.rb`（JWTコントローラーの実装）
- E-02: `lib/gitlab/jwt_token.rb`（JWTトークンクラス）
- E-03: `lib/gitlab/jwt_authenticatable.rb`（JWT認証ベースモジュール）
- E-04: `app/services/auth/container_registry_authentication_service.rb`（Container Registry認証サービス）
- E-05: `app/services/auth/dependency_proxy_authentication_service.rb`（Dependency Proxy認証サービス）
- E-06: `lib/gitlab/auth.rb`（認証共通モジュール）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JWTコントローラーがContainer RegistryとDependency Proxyの認証を担当 | E-01 (16-19行目 SERVICES定数) | ○ |
| C-02 | HTTP Basic認証によるユーザー認証 | E-01 (44行目 authenticate_with_http_basic) | ○ |
| C-03 | サービス名はcontainer_registryとdependency_proxyのみ許可 | E-01 (16-19行目), E-04 (5行目 AUDIENCE), E-05 (5行目 AUDIENCE) | ○ |
| C-04 | 認証失敗時はGitlab::AuthLoggerにログ出力 | E-01 (58-69行目 log_authentication_failed) | ○ |
| C-05 | セッションストレージをスキップ | E-01 (4行目 skip_around_action :set_session_storage) | ○ |
| C-06 | CSRF検証をスキップ | E-01 (6行目 skip_before_action :verify_authenticity_token) | ○ |
| C-07 | scopeパラメータは複数指定可能でスペース区切りもサポート | E-01 (109-118行目 scopes_param) | ○ |
| C-08 | RSA署名によるJWTトークン生成（Container Registry） | E-04 (88-105行目 access_token, 185行目 RSAToken) | ○ |
| C-09 | HMAC署名によるJWTトークン生成（Dependency Proxy） | E-05 (60行目 HMACToken) | ○ |
| C-10 | トークン有効期限はcontainer_registry_token_expire_delay設定に従う | E-04 (107-109行目 token_expire_at) | ○ |
| C-11 | pull/push/delete操作の権限チェック | E-04 (291-306行目 can_access?) | ○ |
| C-12 | ビルドジョブは起動元プロジェクトからの権限継承 | E-04 (322-327行目 build_can_pull?, 358-362行目 build_can_push?) | ○ |
| C-13 | デプロイトークンによる認証サポート | E-01 (100行目), E-04 (340-350行目), E-06 (357-375行目) | ○ |
| C-14 | 個人アクセストークンによる認証サポート | E-01 (47行目), E-06 (297-318行目) | ○ |
| C-15 | レジストリ無効時は404エラー返却 | E-04 (23行目) | ○ |
| C-16 | 権限なし時は403エラー返却 | E-04 (25-28行目) | ○ |
| C-17 | コンテナリポジトリの自動作成（push時） | E-04 (278-283行目 ensure_container_repository!) | ○ |
| C-18 | 保護リポジトリへのプッシュ制限 | E-04 (383-413行目 repository_path_push_protected?) | ○ |
| C-19 | 管理者モードのバイパス機能 | E-01 (127-131行目 bypass_admin_mode!) | ○ |
| C-20 | 秘密鍵は32バイト | E-03 (7行目 SECRET_LENGTH = 32) | ○ |
| C-21 | find_for_git_clientによる認証チェーンの実行 | E-06 (119-147行目) | ○ |
| C-22 | IPレートリミット機能 | E-06 (122-124行目, 196-226行目) | ○ |
| C-23 | user_infoトークンの埋め込み | E-04 (196-215行目 user_info_token) | ○ |
| C-24 | レスポンス時間200ms以内 | **根拠なし** | △ |
| C-25 | スループット1000 req/sec | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（レスポンス時間、スループット）の根拠となるドキュメントや設定が見つからない
  - 候補：GitLab公式ドキュメント / パフォーマンステスト結果 / SLA定義書
- ルーティング設定（/jwt/auth）の確認
  - 候補：`config/routes.rb` / `config/routes/` 配下のファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 認証処理の基本フロー、トークン生成ロジック
- 1: 中リスク - パフォーマンス要件の数値（実測が必要）
- 0: 低リスク - セキュリティ関連の記述（コードで確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件（200ms、1000 req/sec）が実環境で妥当か確認
- [ ] routes.rbでの /jwt/auth ルーティング定義を確認
- [ ] Container Registryの設定（registry.key, registry.issuer）がシステム構成と一致するか確認
- [ ] Dependency Proxyが有効な環境での動作確認
- [ ] デプロイトークンの権限スコープが正しく記載されているか確認
