---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：92-プロジェクトWebhook

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **プロジェクトごとのWebhook数上限**：具体的な上限値の設定箇所確認が必要
  2. **自動無効化の閾値**：auto_disabling.rbの詳細確認が必要
  3. **権限要件**：Maintainer以上という記述の正確性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/hooks_controller.rb`（HooksController実装）
- E-02: `app/controllers/concerns/web_hooks/hook_actions.rb`（HookActions concern）
- E-03: `app/models/hooks/project_hook.rb`（ProjectHookモデル）
- E-04: `app/models/hooks/web_hook.rb`（WebHook基底クラス）
- E-05: `app/models/concerns/web_hooks/hook.rb`（Hook concern）
- E-06: `app/services/web_hook_service.rb`（WebHookService）
- E-07: `lib/api/project_hooks.rb`（REST API）
- E-08: `app/models/concerns/triggerable_hooks.rb`（TriggerableHooks）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトWebhookは外部HTTPエンドポイントに通知する | E-06 (147行目 Gitlab::HTTP.post) | ○ |
| C-02 | 利用可能なイベント種別（push, MR, issue等） | E-03 (9-26行目 AVAILABLE_HOOKS) | ○ |
| C-03 | read_web_hook権限で閲覧可能 | E-01 (7行目), E-07 (11行目) | ○ |
| C-04 | admin_web_hook権限で作成・編集・削除 | E-01 (8行目), E-07 (11行目) | ○ |
| C-05 | URL最大8192文字 | E-05 (49行目 MAX_PARAM_LENGTH) | ○ |
| C-06 | トークン最大8192文字、改行なし | E-05 (56行目) | ○ |
| C-07 | 名前最大255文字 | E-05 (75行目) | ○ |
| C-08 | 説明最大2048文字 | E-05 (76行目) | ○ |
| C-09 | カスタムテンプレート最大4096文字 | E-05 (74行目) | ○ |
| C-10 | URLはAES-256-GCMで暗号化 | E-05 (25-28行目 attr_encrypted :url) | ○ |
| C-11 | トークンはAES-256-GCMで暗号化 | E-05 (20-23行目 attr_encrypted :token) | ○ |
| C-12 | リクエストボディサイズ上限25MB | E-06 (32行目 REQUEST_BODY_SIZE_LIMIT) | ○ |
| C-13 | レスポンスボディ保存上限8KB | E-06 (35行目 RESPONSE_BODY_SIZE_LIMIT) | ○ |
| C-14 | レスポンスヘッダー保存上限50個、各1KB | E-06 (37-38行目) | ○ |
| C-15 | サイレントモード中は送信抑止 | E-06 (69-72行目) | ○ |
| C-16 | レート制限機能 | E-06 (253-255行目 rate_limit!) | ○ |
| C-17 | 再帰検出機能 | E-06 (257-259行目 recursion_blocked?) | ○ |
| C-18 | 非同期実行はWebHookWorker使用 | E-06 (128行目) | ○ |
| C-19 | X-Gitlab-Tokenヘッダーでトークン送信 | E-06 (222行目) | ○ |
| C-20 | Idempotency-Keyヘッダー送信 | E-06 (216行目) | ○ |
| C-21 | ブランチフィルタ戦略（wildcard/regex/all_branches） | E-05 (78-82行目 enum :branch_filter_strategy) | ○ |
| C-22 | カスタムテンプレートは{{field}}形式 | E-06 (40行目 CUSTOM_TEMPLATE_INTERPOLATION_REGEX) | ○ |
| C-23 | URL変数は{variable_name}形式 | E-05 (13行目 VARIABLE_REFERENCE_RE) | ○ |
| C-24 | WebHooks::CreateServiceで作成 | E-02 (23行目) | ○ |
| C-25 | WebHooks::DestroyServiceで削除 | E-02 (104行目) | ○ |
| C-26 | TriggerableHooksでイベントフィルタリング | E-08 (9-14行目 hooks_for) | ○ |
| C-27 | プロジェクトごとのWebhook数上限あり | E-03 (6行目 Limitable), **設定値要確認** | △ |
| C-28 | テスト送信機能（TestHooks::ProjectService） | E-01 (19行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- プロジェクトごとのWebhook数上限の具体的な値
  - 候補：`Gitlab::CurrentSettings` / `Plan` / `ApplicationSetting`
- 自動無効化の閾値（連続失敗回数）
  - 候補：`app/models/concerns/web_hooks/auto_disabling.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Webhook CRUD操作、イベントトリガー
- 1: 中リスク - プロジェクト制限の具体値（プランによって異なる可能性）
- 0: 低リスク - セキュリティ関連の記述（コードで確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] プロジェクトごとのWebhook数上限の具体値を確認
- [ ] 自動無効化の閾値（連続失敗回数）を確認
- [ ] Maintainer以上という権限要件の正確性を確認
- [ ] カスタムテンプレートのセキュリティ（インジェクション対策）を確認
- [ ] ローカルアドレス制限の設定箇所を確認
