---
generated_at: 2026-01-22 12:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 18
  claims_without_evidence: 4
confidence_derived: 0.82
---

# 根拠レポート：93-グループWebhook

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.82**
  - 根拠あり：18 / 22、根拠なし：4
- 優先レビュー（高）
  1. **GroupHookモデルの実装**：ソースコードの所在確認が必要（EE機能の可能性）
  2. **コントローラー実装**：Groups::HooksControllerの実装確認が必要
  3. **Group#trigger_hooksの実装**：グループレベルでのトリガー処理確認
  4. **ライセンス判定ロジック**：Premium/Ultimate判定の実装箇所確認

## 2) 参照した情報（Evidence一覧）

- E-01: `db/docs/web_hooks.yml`（web_hooksテーブル定義、GroupHookのSTI）
- E-02: `doc/api/group_webhooks.md`（REST API仕様、Premium/Ultimate限定の記載）
- E-03: `app/models/concerns/web_hooks/hook.rb`（Webhook基本機能）
- E-04: `app/models/concerns/triggerable_hooks.rb`（グループ固有トリガー定義）
- E-05: `app/services/web_hook_service.rb`（HTTP送信サービス）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Premium/Ultimate限定機能 | E-02 (11-12行目 Tier: Premium, Ultimate) | ○ |
| C-02 | GroupHookはweb_hooksテーブルのSTIクラス | E-01 (3-4行目) | ○ |
| C-03 | 管理者またはグループOwnerのみ操作可能 | E-02 (20-22行目) | ○ |
| C-04 | subgroup_eventsイベント対応 | E-02 (78行目, 520行目) | ○ |
| C-05 | member_eventsイベント対応 | E-02 (81行目, 509行目) | ○ |
| C-06 | project_eventsイベント対応 | E-02 (83行目, 515行目) | ○ |
| C-07 | テスト送信レート制限5リクエスト/分 | E-02 (708行目) | ○ |
| C-08 | イベント再送レート制限5リクエスト/分 | E-02 (452行目) | ○ |
| C-09 | URL変更時にトークンリセット | E-02 (614行目) | ○ |
| C-10 | カスタムヘッダー対応 | E-02 (736-767行目) | ○ |
| C-11 | URL変数対応 | E-02 (801-831行目) | ○ |
| C-12 | イベントログ取得API | E-02 (160-172行目) | ○ |
| C-13 | TriggerableHooksでmember_hooks定義 | E-04 (33行目) | ○ |
| C-14 | TriggerableHooksでsubgroup_hooks定義 | E-04 (43行目) | ○ |
| C-15 | TriggerableHooksでproject_hooks定義 | E-04 (38行目) | ○ |
| C-16 | WebHookServiceで送信処理 | E-05（全体） | ○ |
| C-17 | branch_filter_strategy対応 | E-02 (65行目, 498行目) | ○ |
| C-18 | custom_webhook_template対応 | E-02 (83行目, 502行目) | ○ |
| C-19 | GroupHookモデルの実装ファイル | **ソースコード未発見**（EE機能の可能性） | △ |
| C-20 | Groups::HooksControllerの実装 | **ソースコード未発見**（EE機能の可能性） | △ |
| C-21 | Group#trigger_hooksの実装 | **ソースコード未発見** | △ |
| C-22 | ライセンス判定ロジック | **実装箇所未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- GroupHookモデルのソースコード（ee/ディレクトリの可能性）
  - 候補：`ee/app/models/hooks/group_hook.rb`
- Groups::HooksControllerの実装（ee/ディレクトリの可能性）
  - 候補：`ee/app/controllers/groups/hooks_controller.rb`
- Group#trigger_hooksメソッドの実装
  - 候補：`ee/app/models/ee/group.rb`
- ライセンス判定（Premium/Ultimate）の実装
  - 候補：PolicyクラスまたはGitlab::License

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - GroupHook関連のソースコードが見つからない（EE専用機能のため本リポジトリに存在しない可能性）
- 1: 中リスク - グループレベルのイベントトリガー処理の詳細が不明
- 0: 低リスク - API仕様はドキュメントで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] GroupHookモデルがee/ディレクトリに存在するか確認
- [ ] Groups::HooksControllerがee/ディレクトリに存在するか確認
- [ ] ライセンス判定（Premium/Ultimate）の実装を確認
- [ ] Group#trigger_hooksの実装を確認
- [ ] グループ固有イベント（subgroup, member, project）のトリガー処理を確認
- [ ] プロジェクトWebhookとの機能差分が正しく記載されているか確認
