---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：94-システムWebhook

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **ファイルフック実装の詳細**：Gitlab::FileHookの実装詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/hooks_controller.rb`（管理画面コントローラー）
- E-02: `app/models/hooks/system_hook.rb`（SystemHookモデル）
- E-03: `app/services/system_hooks_service.rb`（システムフックサービス）
- E-04: `lib/api/system_hooks.rb`（REST API）
- E-05: `app/validators/system_hook_url_validator.rb`（URL検証）
- E-06: `app/workers/system_hook_push_worker.rb`（プッシュイベントワーカー）
- E-07: `doc/administration/system_hooks.md`（管理者向けドキュメント）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者のみがシステムWebhookを操作可能 | E-04 (11-14行目 authorize! ability) | ○ |
| C-02 | GitLab.comでは無効化 | E-01 (36-38行目 !Gitlab.com?) | ○ |
| C-03 | AVAILABLE_HOOKSにrepository_update, push, tag_push, merge_request | E-02 (7-12行目) | ○ |
| C-04 | push_eventsデフォルトfalse | E-02 (24行目 attribute :push_events, default: false) | ○ |
| C-05 | repository_update_eventsデフォルトtrue | E-02 (25行目) | ○ |
| C-06 | merge_requests_eventsデフォルトfalse | E-02 (26行目) | ○ |
| C-07 | organization_idが必須 | E-02 (31行目 validates :organization_id, presence: true) | ○ |
| C-08 | allow_local_requests_from_system_hooks設定で制御 | E-02 (34-36行目), E-05 (15-17行目) | ○ |
| C-09 | SystemHooksService.execute_hooks_forでイベントトリガー | E-03 (4-10行目) | ○ |
| C-10 | イベントデータ構築にHookData Builderを使用 | E-03 (22-36行目) | ○ |
| C-11 | User/Project/Group/Key/Member用のBuilderが存在 | E-03 (24-35行目) | ○ |
| C-12 | ファイルフック（Gitlab::FileHook）の実行 | E-03 (17行目) | ○ |
| C-13 | run_after_commit_or_nowでコミット後に実行 | E-03 (7-9行目) | ○ |
| C-14 | SystemHookPushWorkerはリトライ3回 | E-06 (8行目 sidekiq_options retry: 3) | ○ |
| C-15 | REST APIエンドポイント /hooks | E-04 (43行目 resource :hooks) | ○ |
| C-16 | URL変数対応 | E-04 (38行目 use :url_variables) | ○ |
| C-17 | カスタムヘッダー対応 | E-04 (39行目 use :custom_headers) | ○ |
| C-18 | branch_filter_strategy対応 | E-04 (36-37行目) | ○ |
| C-19 | push_event_hooks_limitでプッシュイベント上限 | E-07 (100-106行目) | ○ |
| C-20 | イベント一覧（project_create, user_create等） | E-07 (27-58行目) | ○ |
| C-21 | X-Gitlab-Event: System Hookヘッダー | E-07 (112-114行目) | ○ |
| C-22 | トークンはX-Gitlab-Tokenヘッダーで送信 | E-07 (91-92行目) | ○ |
| C-23 | プッシュ/タグイベントはコミット情報を含まない | E-07 (62-65行目) | ○ |
| C-24 | TestHooks::SystemServiceでテスト送信 | E-01 (11行目) | ○ |
| C-25 | WebHooks::CreateServiceでWebhook作成 | E-04 (95行目) | ○ |
| C-26 | Gitlab::FileHookの実装詳細 | **実装ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- Gitlab::FileHookの実装詳細
  - 候補：`lib/gitlab/file_hook.rb`
- イベント発生時のモデル側の実装（コールバック）
  - 候補：`app/models/user.rb`, `app/models/project.rb`等の after_commit

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - システムWebhookの基本機能、イベント一覧
- 1: 中リスク - ファイルフック機能の詳細（セキュリティ観点で重要）
- 0: 低リスク - API仕様、権限制御

## 6) レビュアーチェックリスト（最小）
- [ ] Gitlab::FileHookの実装と動作を確認
- [ ] イベント発生時のモデル側コールバック実装を確認
- [ ] push_event_hooks_limitの設定可能な範囲を確認
- [ ] organization_id必須化の影響を確認
- [ ] GitLab.com環境での404動作を確認
