---
generated_at: 2026-01-22 13:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：95-Slack連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Maintainer以上の権限要件**：ポリシー実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/integrations/slack.rb`（Slack通知インテグレーション）
- E-02: `app/models/integrations/gitlab_slack_application.rb`（GitLab for Slack app）
- E-03: `app/models/concerns/integrations/slack_mattermost_fields.rb`（共通フィールド）
- E-04: `app/models/concerns/integrations/slack_mattermost_notifier.rb`（Webhook通知）
- E-05: `app/models/concerns/integrations/base/slack_notification.rb`（Slack拡張）
- E-06: `app/models/concerns/integrations/base/chat_notification.rb`（チャット通知基底）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Slack通知はSlackMattermostNotifierを使用 | E-01 (6行目 include SlackMattermostNotifier) | ○ |
| C-02 | GitLab for Slack appはSlack APIを使用 | E-02 (132行目 api_client.post) | ○ |
| C-03 | チャンネル上限10 | E-06 (184-186行目 channel_limit_per_event) | ○ |
| C-04 | SUPPORTED_EVENTS定義 | E-06 (14-17行目) | ○ |
| C-05 | notify_only_broken_pipelines設定 | E-03 (25-29行目) | ○ |
| C-06 | branches_to_be_notified設定 | E-03 (31-39行目) | ○ |
| C-07 | labels_to_be_notified設定 | E-03 (41-46行目) | ○ |
| C-08 | labels_to_be_notified_behavior設定 | E-03 (48-58行目) | ○ |
| C-09 | MATCH_ANY_LABEL/MATCH_ALL_LABELS定義 | E-06 (25-28行目) | ○ |
| C-10 | webhook必須（Slack通知） | E-06 (65-74行目 validates :webhook) | ○ |
| C-11 | イベントごとのチャンネル設定 | E-06 (23行目 EVENT_CHANNEL) | ○ |
| C-12 | confidential_issue_channelの継承 | E-06 (101-103行目) | ○ |
| C-13 | updateアクションは通知しない | E-06 (306-308行目 update?) | ○ |
| C-14 | Slack::Messenger.pingで送信 | E-04 (16-21行目) | ○ |
| C-15 | alert_eventsはSlack固有 | E-05 (18-21行目 supported_events + alert) | ○ |
| C-16 | GitLab for Slack appはOAuth認証後に編集可能 | E-02 (55-58行目 editable?) | ○ |
| C-17 | bot_access_token使用 | E-02 (21行目 delegate :bot_access_token) | ○ |
| C-18 | chat.postMessage API使用 | E-02 (133-135行目) | ○ |
| C-19 | slack_integrationsテーブル使用 | E-02 (20行目 has_one :slack_integration) | ○ |
| C-20 | 使用状況ログ（HLLカウンター） | E-05 (66行目 HLLRedisCounter.track_event) | ○ |
| C-21 | エラー時のログ出力 | E-04 (26-30行目 log_error), E-02 (137行目 log_error) | ○ |
| C-22 | イベントデータに基づくメッセージ選択 | E-06 (265-284行目 get_message) | ○ |
| C-23 | notify_for_ref?でブランチフィルタ | E-06 (314-326行目) | ○ |
| C-24 | チャンネル数上限バリデーション | E-06 (352-365行目 validate_channel_limit) | ○ |
| C-25 | Maintainer以上が設定可能 | **ポリシー実装未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- インテグレーション設定の権限要件（Maintainer以上）の実装確認
  - 候補：`app/policies/integration_policy.rb`
- Slack APIエラーの詳細ハンドリング
  - 候補：Slack gem / HTTPエラー処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Slack連携の基本機能、メッセージ構築
- 1: 中リスク - 権限要件の正確性（ポリシー確認が必要）
- 0: 低リスク - チャンネル数上限、ラベルフィルタ

## 6) レビュアーチェックリスト（最小）
- [ ] IntegrationPolicyでMaintainer以上の権限チェックを確認
- [ ] Slack APIエラー時のリトライ/フォールバック動作を確認
- [ ] slack_integrationsテーブルの暗号化設定を確認
- [ ] GitLab for Slack appの再インストール時の挙動を確認
- [ ] グループレベルでのgroup_mentionイベント動作を確認
