---
generated_at: 2026-01-22 13:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：96-Jira連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Maintainer以上の権限要件**：インテグレーション設定のポリシー確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/integrations/jira.rb`（Jira連携メインクラス）
- E-02: `app/models/integrations/jira_tracker_data.rb`（Jira設定データモデル）
- E-03: `app/models/integrations/jira_cloud_app.rb`（Jira Cloud App連携）
- E-04: `app/models/concerns/integrations/base/issue_tracker.rb`（イシュートラッカー基底）
- E-05: `lib/gitlab/jira/http_client.rb`（Jira HTTPクライアント）
- E-06: `doc/user/project/integrations/jira.md`（ユーザードキュメント）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | commit, merge_requestイベントをサポート | E-01 (190-192行目 supported_events) | ○ |
| C-02 | API_ENDPOINTS定義（JIRA_SEARCH, JIRA_ISSUE等） | E-01 (24-31行目) | ○ |
| C-03 | jira_auth_typeによる認証タイプ切り替え | E-01 (44-60行目), E-02 | ○ |
| C-04 | find_issueでJiraイシュー取得 | E-01 (356-367行目) | ○ |
| C-05 | close_issueでイシュークローズ | E-01 (369-387行目) | ○ |
| C-06 | create_cross_reference_noteでクロスリファレンス作成 | E-01 (389-425行目) | ○ |
| C-07 | transition_issueでステータス遷移 | E-01 (510-546行目) | ○ |
| C-08 | jira_issue_transition_automaticで自動遷移 | E-01 (524-536行目 done_transition_id) | ○ |
| C-09 | deployment_type（cloud, server, data_center） | E-02 (23-27行目) | ○ |
| C-10 | encrypted_passwordで認証情報暗号化 | E-02 (14行目 attr_encrypted) | ○ |
| C-11 | project_keysでJiraプロジェクト絞り込み | E-02 (16-21行目 serialized_properties) | ○ |
| C-12 | JIRA::Clientを使用（jira-ruby gem） | E-01 (347行目 JIRA::Client.new) | ○ |
| C-13 | Gitlab::Jira::HttpClientをHTTPクライアントとして使用 | E-01 (350行目), E-05 | ○ |
| C-14 | Basic認証でusername/password使用 | E-01 (101-103行目), E-05 (35-40行目) | ○ |
| C-15 | PAT認証でBearerトークン使用 | E-01 (105-107行目), E-05 (42-44行目) | ○ |
| C-16 | jira_issue_regexでカスタム正規表現 | E-01 (66-68行目 reference_pattern) | ○ |
| C-17 | jira_issue_prefixでデフォルトプロジェクトキー | E-01 (70-74行目) | ○ |
| C-18 | comment_on_event_enabledでコメント投稿制御 | E-01 (389-396行目) | ○ |
| C-19 | 重複コメント防止（existing_comment_match） | E-01 (409-416行目) | ○ |
| C-20 | リモートリンク作成（add_remote_link） | E-01 (418-425行目) | ○ |
| C-21 | issues_enabled（Premium機能） | E-01 (85-87行目), E-06 | ○ |
| C-22 | Jira Cloud App連携 | E-03 | ○ |
| C-23 | test_settings（接続テスト） | E-01 (194-212行目) | ○ |
| C-24 | 使用状況ログ（Gitlab::UsageDataCounters） | E-01 (183-188行目) | ○ |
| C-25 | integrationsテーブルに設定保存 | E-01 (type定義), E-02 | ○ |
| C-26 | jira_tracker_dataテーブルに認証情報保存 | E-02 (has_one :jira_tracker_data) | ○ |
| C-27 | vulnerabilities_enabled（Ultimate機能） | E-01 (89-91行目) | ○ |
| C-28 | Maintainer以上が設定可能 | **ポリシー実装未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- インテグレーション設定の権限要件（Maintainer以上）の実装確認
  - 候補：`app/policies/integration_policy.rb`
- Jira APIエラーのリトライ戦略
  - 候補：`lib/gitlab/jira/http_client.rb`のエラーハンドリング
- JiraイシューのWebhook連携（Jira→GitLab方向）
  - Premium/Ultimate機能の可能性

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Jira連携の基本機能、API呼び出し
- 1: 中リスク - 権限要件の正確性（ポリシー確認が必要）
- 0: 低リスク - 認証情報の暗号化、クロスリファレンス

## 6) レビュアーチェックリスト（最小）
- [ ] IntegrationPolicyでMaintainer以上の権限チェックを確認
- [ ] Jira API認証エラー時のリトライ動作を確認
- [ ] jira_tracker_dataテーブルの暗号化設定を確認
- [ ] Jira Cloud/Data Centerでの認証方式の違いを確認
- [ ] Premium/Ultimate機能（issues_enabled, vulnerabilities_enabled）の動作確認
