---
generated_at: 2026-01-22 13:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：97-Mattermost連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **Maintainer以上の権限要件**：ポリシー実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/integrations/mattermost.rb`（Mattermost通知インテグレーション）
- E-02: `app/models/integrations/mattermost_slash_commands.rb`（スラッシュコマンドモデル）
- E-03: `app/models/concerns/integrations/base/mattermost_slash_commands.rb`（スラッシュコマンド実装）
- E-04: `app/models/concerns/integrations/slack_mattermost_notifier.rb`（Webhook通知）
- E-05: `app/models/concerns/integrations/slack_mattermost_fields.rb`（共通フィールド）
- E-06: `app/models/concerns/integrations/base/chat_notification.rb`（チャット通知基底）
- E-07: `lib/mattermost/session.rb`（SSOセッション管理）
- E-08: `lib/mattermost/client.rb`（APIクライアント）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ChatNotification, SlackMattermostNotifier, SlackMattermostFieldsを使用 | E-01 (5-7行目 include) | ○ |
| C-02 | configurable_channels?がtrue | E-01 (36-39行目) | ○ |
| C-03 | Slack::Messenger使用でWebhook送信 | E-04 (16行目 ::Slack::Messenger.new) | ○ |
| C-04 | notifier.pingでメッセージ送信 | E-04 (17-21行目) | ○ |
| C-05 | HTTPエラー時のログ出力 | E-04 (26-30行目 log_error) | ○ |
| C-06 | webhook必須フィールド | E-05 (8-14行目) | ○ |
| C-07 | notify_only_broken_pipelines設定 | E-05 (25-29行目) | ○ |
| C-08 | branches_to_be_notified設定 | E-05 (31-39行目) | ○ |
| C-09 | labels_to_be_notified設定 | E-05 (41-46行目) | ○ |
| C-10 | labels_to_be_notified_behavior設定 | E-05 (48-58行目) | ○ |
| C-11 | SUPPORTED_EVENTS定義 | E-06 (14-17行目) | ○ |
| C-12 | チャンネル上限10 | E-06 (184-186行目 channel_limit_per_event) | ○ |
| C-13 | updateイベントは通知対象外 | E-06 (306-308行目 update?) | ○ |
| C-14 | スラッシュコマンドトークンフィールド | E-03 (28-34行目) | ○ |
| C-15 | Mattermost API v4使用 | E-03 (6行目 /api/v4/commands) | ○ |
| C-16 | configure メソッドでコマンド登録 | E-03 (44-52行目) | ○ |
| C-17 | list_teams メソッドでチーム一覧取得 | E-03 (54-58行目) | ○ |
| C-18 | redirect_urlでURLブロッカー使用 | E-03 (61-66行目 UrlBlocker.blocked_url?) | ○ |
| C-19 | LEASE_TIMEOUT = 60秒 | E-07 (28行目) | ○ |
| C-20 | with_sessionでセッション管理 | E-07 (41-54行目) | ○ |
| C-21 | OAuth経由でトークン取得 | E-07 (107-119行目 create) | ○ |
| C-22 | Bearer認証ヘッダー使用 | E-07 (114-116行目) | ○ |
| C-23 | 排他制御（ExclusiveLease）使用 | E-07 (159-177行目) | ○ |
| C-24 | Maintainer以上が設定可能 | **ポリシー実装未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- インテグレーション設定の権限要件（Maintainer以上）の実装確認
  - 候補：`app/policies/integration_policy.rb`
- スラッシュコマンドコントローラーの実装詳細
  - 候補：`app/controllers/projects/integrations/slash_commands_controller.rb`
- Mattermost側の設定要件
  - 候補：公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Mattermost通知の基本機能、メッセージ構築
- 1: 中リスク - 権限要件の正確性（ポリシー確認が必要）
- 0: 低リスク - SSO認証、排他制御

## 6) レビュアーチェックリスト（最小）
- [ ] IntegrationPolicyでMaintainer以上の権限チェックを確認
- [ ] Mattermostセッションのリース競合時の動作を確認
- [ ] スラッシュコマンドコントローラーのトークン検証を確認
- [ ] Mattermost SSO設定がない場合のエラーハンドリングを確認
- [ ] Slack::Messenger gemのMattermost互換性を確認
