---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：98-外部イシュートラッカー連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Banzai参照フィルターの実装詳細**：実際のリンク生成処理の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/concerns/integrations/base/issue_tracker.rb`（イシュートラッカー基底）
- E-02: `app/models/concerns/integrations/has_issue_tracker_fields.rb`（共通フィールド）
- E-03: `app/models/concerns/integrations/base/redmine.rb`（Redmine連携）
- E-04: `app/models/concerns/integrations/base/bugzilla.rb`（Bugzilla連携）
- E-05: `app/models/concerns/integrations/base/youtrack.rb`（YouTrack連携）
- E-06: `app/models/concerns/integrations/base/custom_issue_tracker.rb`（カスタムトラッカー）
- E-07: `app/models/integrations/issue_tracker_data.rb`（データモデル）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | REFERENCE_PATTERN定義（PROJECT-123形式） | E-01 (8-9行目) | ○ |
| C-02 | one_issue_trackerバリデーション（排他制御） | E-01 (12行目 validate :one_issue_tracker) | ○ |
| C-03 | category = 'issue_tracker' | E-01 (14行目) | ○ |
| C-04 | supported_events = ['push'] | E-01 (21-23行目) | ○ |
| C-05 | issue_urlメソッドで:id置換 | E-01 (74-76行目 gsub(':id', iid.to_s)) | ○ |
| C-06 | executeでHEAD接続テスト | E-01 (102-125行目 Clients::HTTP.head) | ○ |
| C-07 | field_storage = :data_fields | E-02 (8行目) | ○ |
| C-08 | project_url必須フィールド | E-02 (10-14行目) | ○ |
| C-09 | issues_urlに:idプレースホルダー | E-02 (16-26行目 help) | ○ |
| C-10 | new_issue_url必須フィールド | E-02 (28-32行目) | ○ |
| C-11 | Redmine: 3つのURL必須 | E-03 (33行目 validates) | ○ |
| C-12 | Bugzilla: attribution_notice（商標表記） | E-04 (27-29行目) | ○ |
| C-13 | Bugzilla: 3つのURL必須 | E-04 (37行目) | ○ |
| C-14 | YouTrack: FIELDS = ['project_url', 'issues_url'] | E-05 (12行目) | ○ |
| C-15 | YouTrack: fieldsメソッドオーバーライド | E-05 (34-36行目) | ○ |
| C-16 | YouTrack: 独自reference_pattern（小文字許可） | E-05 (48-53行目) | ○ |
| C-17 | カスタムトラッカー: 3つのURL必須 | E-06 (33行目) | ○ |
| C-18 | URL暗号化（attr_encrypted） | E-07 (9-11行目) | ○ |
| C-19 | URL長さ制限（2048文字） | E-07 (15-17行目 length: { maximum: 2048 }) | ○ |
| C-20 | パブリックURL検証 | E-03 (33行目 public_url: true) | ○ |
| C-21 | other_external_issue_trackersで排他チェック | E-01 (145-148行目) | ○ |
| C-22 | Banzaiフィルターでイシュー参照リンク化 | **実装ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- Banzai::Filter::ExternalIssueReferenceFilterの実装詳細
  - 候補：`lib/banzai/filter/external_issue_reference_filter.rb`
- 設定UIコントローラーの実装
  - 候補：`app/controllers/projects/settings/integrations_controller.rb`
- Pivotal Trackerの実装詳細（pivotaltracker.rb）
  - 別のイシュートラッカーとして存在するが設計書では言及なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 外部イシュートラッカーの基本設定
- 1: 中リスク - Banzaiフィルターの実装詳細（リンク生成）
- 0: 低リスク - データ暗号化、バリデーション

## 6) レビュアーチェックリスト（最小）
- [ ] ExternalIssueReferenceFilterの実装を確認
- [ ] 排他制御（one_issue_tracker）の動作を確認
- [ ] パブリックURL検証の詳細（ブロックリスト）を確認
- [ ] Pivotal Trackerインテグレーションの扱いを確認
- [ ] issue_urlの:id置換時のセキュリティ（URL injection防止）を確認
