---
generated_at: 2026-01-22 14:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：99-メールオンプッシュ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Maintainer以上の権限要件**：ポリシー実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/concerns/integrations/base/emails_on_push.rb`（EmailsOnPush実装）
- E-02: `app/workers/emails_on_push_worker.rb`（バックグラウンドワーカー）
- E-03: `app/mailers/emails/projects.rb`（メーラー）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RECIPIENTS_LIMIT = 750 | E-01 (9行目) | ○ |
| C-02 | valid_recipientsでメール形式検証 | E-01 (12-14行目 grep(Devise.email_regexp)) | ○ |
| C-03 | supported_events = ['push', 'tag_push'] | E-01 (28-30行目) | ○ |
| C-04 | recipients必須バリデーション | E-01 (34行目) | ○ |
| C-05 | number_of_recipients_within_limit | E-01 (35行目, 112-123行目) | ○ |
| C-06 | send_from_committer_emailフィールド | E-01 (37-50行目) | ○ |
| C-07 | disable_diffsフィールド | E-01 (52-56行目) | ○ |
| C-08 | branches_to_be_notifiedフィールド | E-01 (58-65行目) | ○ |
| C-09 | branches_to_be_notifiedデフォルト'all' | E-01 (77行目) | ○ |
| C-10 | EmailsOnPushWorker.perform_asyncで非同期 | E-01 (86-92行目) | ○ |
| C-11 | tag_pushは常に通知対象 | E-01 (96行目) | ○ |
| C-12 | notify_for_branch?でブランチフィルタ | E-01 (99行目) | ○ |
| C-13 | sidekiq_options retry: 3 | E-02 (8行目) | ○ |
| C-14 | アクション判定（create/delete/push） | E-02 (32-39行目) | ○ |
| C-15 | CompareServiceでdiff取得 | E-02 (46-60行目) | ○ |
| C-16 | 逆方向比較（reverse_compare） | E-02 (53-57行目) | ○ |
| C-17 | SMTPエラーハンドリング | E-02 (78-79行目) | ○ |
| C-18 | GC.startでメモリ解放 | E-02 (84行目) | ○ |
| C-19 | repository_push_emailメソッド | E-03 (96-113行目) | ○ |
| C-20 | send_from_user_email対応 | E-03 (109行目) | ○ |
| C-21 | Premailer::Rails::Hook使用 | E-02 (91行目) | ○ |
| C-22 | Maintainer以上が設定可能 | **ポリシー実装未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- インテグレーション設定の権限要件（Maintainer以上）の実装確認
  - 候補：`app/policies/integration_policy.rb`
- Gitlab::Email::Message::RepositoryPushの実装詳細
  - 候補：`lib/gitlab/email/message/repository_push.rb`
- emails_disabled?の実装詳細
  - 候補：`app/models/project.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信の基本機能
- 1: 中リスク - 権限要件の正確性（ポリシー確認が必要）
- 0: 低リスク - 受信者数制限、ブランチフィルタ

## 6) レビュアーチェックリスト（最小）
- [ ] IntegrationPolicyでMaintainer以上の権限チェックを確認
- [ ] SMTPエラー時のリトライ動作を確認
- [ ] 大量コミットプッシュ時のメモリ使用量を確認
- [ ] send_from_committer_emailのドメイン制限を確認
- [ ] emails_disabled?設定の影響範囲を確認
