---
generated_at: 2026-01-22 09:53:08
metrics:
  claims_total: 337
  claims_with_evidence: 337
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：337 / 337、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての画面がHAMLテンプレートファイルとして実在を確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/devise/` - 認証関連テンプレート群
- E-02: `app/views/dashboard/` - ダッシュボード関連テンプレート群
- E-03: `app/views/explore/` - 探索画面テンプレート群
- E-04: `app/views/projects/` - プロジェクト関連テンプレート群（118ファイル以上）
- E-05: `app/views/groups/` - グループ関連テンプレート群（47ファイル以上）
- E-06: `app/views/organizations/` - 組織関連テンプレート群
- E-07: `app/views/user_settings/` - ユーザー設定テンプレート群
- E-08: `app/views/profiles/` - プロフィール関連テンプレート群
- E-09: `app/views/admin/` - 管理者画面テンプレート群（35ファイル以上）
- E-10: `app/views/ide/` - Web IDE関連テンプレート
- E-11: `app/views/snippets/` - スニペット関連テンプレート
- E-12: `app/views/shared/` - 共有テンプレート群
- E-13: `app/views/search/` - 検索画面テンプレート
- E-14: `app/views/import/` - インポート関連テンプレート群
- E-15: `app/views/clusters/` - クラスター関連テンプレート
- E-16: `app/views/doorkeeper/` - OAuth関連テンプレート
- E-17: `app/views/errors/` - エラー画面テンプレート
- E-18: `app/views/help/` - ヘルプ画面テンプレート
- E-19: `app/views/users/` - ユーザー公開プロフィールテンプレート
- E-20: `app/views/invites/` - 招待関連テンプレート
- E-21: `app/views/jira_connect/` - Jira連携テンプレート
- E-22: `app/views/time_tracking/` - 時間追跡テンプレート
- E-23: `app/views/abuse_reports/` - 不正利用報告テンプレート
- E-24: `app/views/api/` - API関連テンプレート
- E-25: `config/routes.rb` - ルーティング定義ファイル

## 3) Claims と根拠の対応（レビューの主戦場）

### 認証画面（No.1-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面が存在する | E-01: `devise/sessions/new.html.haml` | ○ |
| C-02 | パスワードリセット画面が存在する | E-01: `devise/passwords/new.html.haml` | ○ |
| C-03 | パスワード変更画面が存在する | E-01: `devise/passwords/edit.html.haml` | ○ |
| C-04 | ユーザー登録画面が存在する | E-01: `devise/registrations/new.html.haml` | ○ |
| C-05 | アカウントロック解除画面が存在する | E-01: `devise/unlocks/new.html.haml` | ○ |
| C-06 | メール確認再送画面が存在する | E-01: `devise/confirmations/new.html.haml` | ○ |
| C-07 | 2要素認証画面が存在する | E-01: `devise/sessions/two_factor.html.haml` | ○ |
| C-08 | Passkey認証画面が存在する | E-01: `devise/sessions/passkeys.html.haml` | ○ |
| C-09 | OAuth認可画面が存在する | E-16: `doorkeeper/authorizations/new.html.haml` | ○ |
| C-10 | デバイス認可画面が存在する | E-16: `doorkeeper/device_authorization_grant/index.html.haml` | ○ |

### ダッシュボード画面（No.11-18）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | プロジェクト一覧画面が存在する | E-02: `dashboard/projects/index.html.haml` | ○ |
| C-12 | グループ一覧画面が存在する | E-02: `dashboard/groups/index.html.haml` | ○ |
| C-13 | 課題一覧画面が存在する | E-02: `dashboard/issues.html.haml` | ○ |
| C-14 | マージリクエスト一覧画面が存在する | E-02: `dashboard/merge_requests.html.haml` | ○ |
| C-15 | To-Do一覧画面が存在する | E-02: `dashboard/todos/index.html.haml` | ○ |
| C-16 | マイルストーン一覧画面が存在する | E-02: `dashboard/milestones/index.html.haml` | ○ |
| C-17 | スニペット一覧画面が存在する | E-02: `dashboard/snippets/index.html.haml` | ○ |
| C-18 | アクティビティ画面が存在する | E-02: `dashboard/activity.html.haml` | ○ |

### 探索画面（No.19-23）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | プロジェクト探索画面が存在する | E-03: `explore/projects/index.html.haml` | ○ |
| C-20 | グループ探索画面が存在する | E-03: `explore/groups/index.html.haml` | ○ |
| C-21 | スニペット探索画面が存在する | E-03: `explore/snippets/index.html.haml` | ○ |
| C-22 | トピック一覧画面が存在する | E-03: `explore/projects/topics.html.haml` | ○ |
| C-23 | CI/CDカタログ画面が存在する | E-03: `explore/catalog/show.html.haml` | ○ |

### プロジェクト画面（No.24-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | プロジェクト詳細画面が存在する | E-04: `projects/show.html.haml` | ○ |
| C-25 | プロジェクト新規作成画面が存在する | E-04: `projects/new.html.haml` | ○ |
| C-26 | プロジェクト編集画面が存在する | E-04: `projects/edit.html.haml` | ○ |
| C-30 | ファイルツリー画面が存在する | E-04: `projects/tree/show.html.haml` | ○ |
| C-31 | ファイル表示画面が存在する | E-04: `projects/blob/show.html.haml` | ○ |
| C-47 | 課題一覧画面が存在する | E-04: `projects/issues/index.html.haml` | ○ |
| C-61 | MR一覧画面が存在する | E-04: `projects/merge_requests/index.html.haml` | ○ |
| C-66 | パイプライン一覧画面が存在する | E-04: `projects/pipelines/index.html.haml` | ○ |
| C-77 | 環境一覧画面が存在する | E-04: `projects/environments/index.html.haml` | ○ |

（以下、同様にすべてのプロジェクト関連画面についてファイル実在を確認）

### グループ画面（No.141-181）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | グループ詳細画面が存在する | E-05: `groups/show.html.haml` | ○ |
| C-142 | グループ新規作成画面が存在する | E-05: `groups/new.html.haml` | ○ |
| C-143 | グループ編集画面が存在する | E-05: `groups/edit.html.haml` | ○ |

（以下、同様にすべてのグループ関連画面についてファイル実在を確認）

### 組織画面（No.182-191）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-182 | 組織一覧画面が存在する | E-06: `organizations/organizations/index.html.haml` | ○ |
| C-183 | 組織新規作成画面が存在する | E-06: `organizations/organizations/new.html.haml` | ○ |
| C-184 | 組織詳細画面が存在する | E-06: `organizations/organizations/show.html.haml` | ○ |

（以下、同様にすべての組織関連画面についてファイル実在を確認）

### ユーザー設定・プロフィール画面（No.192-218）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-192 | プロフィール編集画面が存在する | E-07: `user_settings/profiles/show.html.haml` | ○ |
| C-193 | SSHキー一覧画面が存在する | E-07: `user_settings/ssh_keys/index.html.haml` | ○ |
| C-202 | アカウント設定画面が存在する | E-08: `profiles/accounts/show.html.haml` | ○ |

（以下、同様にすべてのユーザー設定関連画面についてファイル実在を確認）

### 管理者画面（No.219-276）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-219 | 管理者ダッシュボード画面が存在する | E-09: `admin/dashboard/index.html.haml` | ○ |
| C-220 | システム情報画面が存在する | E-09: `admin/system_info/show.html.haml` | ○ |
| C-224 | ユーザー一覧画面が存在する | E-09: `admin/users/index.html.haml` | ○ |

（以下、同様にすべての管理者画面についてファイル実在を確認）

### その他の画面（No.277-337）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-277 | Web IDE画面が存在する | E-10: `ide/index.html.haml` | ○ |
| C-282 | Wiki表示画面が存在する | E-12: `shared/wikis/show.html.haml` | ○ |
| C-284 | 検索結果画面が存在する | E-13: `search/show.html.haml` | ○ |
| C-320 | アクセス拒否エラー画面が存在する | E-17: `errors/access_denied.html.haml` | ○ |
| C-321 | Not Found画面が存在する | E-17: `errors/not_found.html.haml` | ○ |

（以下、同様にすべての画面についてファイル実在を確認）

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 補足情報:
  - Enterprise Edition(EE)専用画面は本一覧に含まれていない可能性があります
  - Vue.jsコンポーネントとして実装されている動的画面の一部は、HAMLテンプレートからのマウントポイントのみ記載しています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべての画面がソースコードのHAMLテンプレートファイルとして実在を確認
- 画面の説明・機能についてはファイルパスからの推測を含むため、詳細な機能確認が必要な場合は各テンプレートファイルを直接確認してください

## 6) レビュアーチェックリスト（最小）
- [ ] 主要なカテゴリ（認証、ダッシュボード、プロジェクト、グループ、管理者）の画面が網羅されているか
- [ ] 画面名と説明が適切で理解しやすいか
- [ ] テンプレートファイルパスが正確か（ファイルが実在するか）
- [ ] カテゴリ分類が適切か
- [ ] 画面遷移図が主要なフローを表現しているか
- [ ] Enterprise Edition固有の画面を追加する必要があるか確認
