# GitLab 画面遷移図

本ドキュメントはGitLabの主要な画面遷移をMermaid形式で図示したものです。

## 全体概要

```mermaid
flowchart TB
    subgraph 認証フロー
        Login[ログイン画面]
        Register[ユーザー登録画面]
        PasswordReset[パスワードリセット]
        TwoFactor[2要素認証]
        OAuth[OAuth認可]
    end

    subgraph メインナビゲーション
        Dashboard[ダッシュボード]
        Explore[探索]
        Projects[プロジェクト]
        Groups[グループ]
        Organizations[組織]
        Admin[管理者エリア]
    end

    Login --> Dashboard
    Login --> TwoFactor
    TwoFactor --> Dashboard
    Register --> Dashboard
    OAuth --> Dashboard

    Dashboard --> Projects
    Dashboard --> Groups
    Dashboard --> Organizations
    Dashboard --> Explore
    Dashboard --> Admin
```

## 認証フロー

```mermaid
flowchart TD
    Start((開始)) --> Login[ログイン画面]
    Start --> Register[ユーザー登録画面]

    Login --> CheckCredentials{認証成功?}
    CheckCredentials -->|No| Login
    CheckCredentials -->|Yes| Has2FA{2FA有効?}

    Has2FA -->|No| Dashboard[ダッシュボード]
    Has2FA -->|Yes| TwoFactor[2要素認証画面]

    TwoFactor --> Verify2FA{認証成功?}
    Verify2FA -->|No| TwoFactor
    Verify2FA -->|Yes| Dashboard

    Login --> ForgotPassword[パスワードリセット画面]
    ForgotPassword --> PasswordEdit[パスワード変更画面]
    PasswordEdit --> Login

    Login --> UnlockAccount[アカウントロック解除]
    UnlockAccount --> Login

    Login --> ResendConfirmation[メール確認再送]

    Login --> OAuthAuth[OAuth認可画面]
    OAuthAuth --> Dashboard

    Login --> PasskeyAuth[Passkey認証]
    PasskeyAuth --> Dashboard

    Register --> ConfirmEmail{メール確認}
    ConfirmEmail --> Login
```

## ダッシュボードフロー

```mermaid
flowchart TD
    Dashboard[ダッシュボード] --> ProjectList[プロジェクト一覧]
    Dashboard --> GroupList[グループ一覧]
    Dashboard --> Issues[課題一覧]
    Dashboard --> MergeRequests[マージリクエスト一覧]
    Dashboard --> Todos[To-Do一覧]
    Dashboard --> Milestones[マイルストーン一覧]
    Dashboard --> Snippets[スニペット一覧]
    Dashboard --> Activity[アクティビティ]

    ProjectList --> ProjectDetail[プロジェクト詳細]
    GroupList --> GroupDetail[グループ詳細]
    Snippets --> SnippetNew[スニペット新規作成]
    Snippets --> SnippetDetail[スニペット詳細]
```

## 探索フロー

```mermaid
flowchart TD
    Explore[探索トップ] --> ExploreProjects[プロジェクト探索]
    Explore --> ExploreGroups[グループ探索]
    Explore --> ExploreSnippets[スニペット探索]
    Explore --> Topics[トピック一覧]
    Explore --> Catalog[CI/CDカタログ]

    ExploreProjects --> ProjectDetail[プロジェクト詳細]
    ExploreGroups --> GroupDetail[グループ詳細]
    Topics --> TopicDetail[トピック詳細]
    Catalog --> CatalogDetail[カタログ詳細]
```

## プロジェクト画面フロー

```mermaid
flowchart TD
    subgraph プロジェクトトップ
        ProjectTop[プロジェクト詳細]
        ProjectEdit[プロジェクト編集]
        ProjectNew[プロジェクト新規作成]
    end

    subgraph リポジトリ
        Tree[ファイルツリー]
        Blob[ファイル表示]
        BlobNew[ファイル新規作成]
        BlobEdit[ファイル編集]
        Blame[Blame表示]
        Branches[ブランチ一覧]
        BranchNew[ブランチ新規作成]
        Tags[タグ一覧]
        TagNew[タグ新規作成]
        Commits[コミット一覧]
        CommitDetail[コミット詳細]
        Compare[比較画面]
        Network[ネットワークグラフ]
        Graphs[貢献者グラフ]
    end

    subgraph 課題管理
        IssueList[課題一覧]
        IssueNew[課題新規作成]
        IssueDetail[課題詳細]
        Boards[ボード一覧]
        BoardDetail[ボード表示]
        MilestoneList[マイルストーン一覧]
        MilestoneNew[マイルストーン新規作成]
        MilestoneDetail[マイルストーン詳細]
        Labels[ラベル一覧]
    end

    subgraph マージリクエスト
        MRList[MR一覧]
        MRNew[MR新規作成]
        MRDetail[MR詳細]
        MREdit[MR編集]
        Conflicts[コンフリクト解決]
    end

    ProjectTop --> Tree
    ProjectTop --> IssueList
    ProjectTop --> MRList
    ProjectTop --> ProjectEdit

    Tree --> Blob
    Tree --> BlobNew
    Blob --> BlobEdit
    Blob --> Blame
    Tree --> Branches
    Branches --> BranchNew
    Tree --> Tags
    Tags --> TagNew
    Tree --> Commits
    Commits --> CommitDetail
    Tree --> Compare
    Tree --> Network
    Tree --> Graphs

    IssueList --> IssueNew
    IssueList --> IssueDetail
    IssueList --> Boards
    Boards --> BoardDetail
    IssueList --> MilestoneList
    MilestoneList --> MilestoneNew
    MilestoneList --> MilestoneDetail
    IssueList --> Labels

    MRList --> MRNew
    MRList --> MRDetail
    MRDetail --> MREdit
    MRDetail --> Conflicts
```

## CI/CDフロー

```mermaid
flowchart TD
    subgraph パイプライン
        PipelineList[パイプライン一覧]
        PipelineNew[パイプライン新規作成]
        PipelineDetail[パイプライン詳細]
        PipelineEditor[パイプラインエディタ]
        CILint[CI Lint]
    end

    subgraph ジョブ
        JobList[ジョブ一覧]
        JobDetail[ジョブ詳細]
        Artifacts[アーティファクト一覧]
    end

    subgraph スケジュール
        ScheduleList[スケジュール一覧]
        ScheduleNew[スケジュール新規作成]
        ScheduleEdit[スケジュール編集]
    end

    PipelineList --> PipelineNew
    PipelineList --> PipelineDetail
    PipelineDetail --> JobDetail
    PipelineList --> PipelineEditor
    PipelineEditor --> CILint

    JobList --> JobDetail
    JobDetail --> Artifacts

    ScheduleList --> ScheduleNew
    ScheduleList --> ScheduleEdit
    ScheduleNew --> PipelineList
```

## 環境・デプロイフロー

```mermaid
flowchart TD
    subgraph 環境
        EnvList[環境一覧]
        EnvNew[環境新規作成]
        EnvDetail[環境詳細]
        EnvEdit[環境編集]
        DeployDetail[デプロイ詳細]
    end

    subgraph フィーチャーフラグ
        FFList[フィーチャーフラグ一覧]
        FFNew[フィーチャーフラグ新規作成]
        FFEdit[フィーチャーフラグ編集]
    end

    subgraph リリース
        ReleaseList[リリース一覧]
        ReleaseNew[リリース新規作成]
        ReleaseDetail[リリース詳細]
        ReleaseEdit[リリース編集]
    end

    EnvList --> EnvNew
    EnvList --> EnvDetail
    EnvDetail --> EnvEdit
    EnvDetail --> DeployDetail

    FFList --> FFNew
    FFList --> FFEdit

    ReleaseList --> ReleaseNew
    ReleaseList --> ReleaseDetail
    ReleaseDetail --> ReleaseEdit
```

## グループ画面フロー

```mermaid
flowchart TD
    subgraph グループトップ
        GroupTop[グループ詳細]
        GroupNew[グループ新規作成]
        GroupEdit[グループ編集]
    end

    subgraph メンバー管理
        Members[メンバー一覧]
    end

    subgraph 課題管理
        GLabels[ラベル一覧]
        GMilestones[マイルストーン一覧]
        GBoards[ボード一覧]
        GWorkItems[作業アイテム一覧]
    end

    subgraph パッケージ
        GPackages[パッケージ一覧]
        GRegistry[コンテナレジストリ]
    end

    subgraph Runner
        GRunners[Runner一覧]
        GRunnerNew[Runner新規登録]
        GRunnerDetail[Runner詳細]
    end

    GroupTop --> Members
    GroupTop --> GLabels
    GroupTop --> GMilestones
    GroupTop --> GBoards
    GroupTop --> GWorkItems
    GroupTop --> GPackages
    GroupTop --> GRegistry
    GroupTop --> GRunners
    GroupTop --> GroupEdit

    GRunners --> GRunnerNew
    GRunners --> GRunnerDetail
```

## ユーザー設定フロー

```mermaid
flowchart TD
    subgraph プロフィール設定
        Profile[プロフィール編集]
        Account[アカウント設定]
        Preferences[表示設定]
        Notifications[通知設定]
    end

    subgraph セキュリティ
        SSHKeys[SSHキー一覧]
        GPGKeys[GPGキー一覧]
        Password[パスワード変更]
        TwoFactorAuth[2要素認証設定]
        AccessTokens[アクセストークン一覧]
        ActiveSessions[アクティブセッション一覧]
    end

    subgraph その他
        Emails[メール管理]
        ChatNames[チャット名管理]
        CommentTemplates[コメントテンプレート]
        UsageQuotas[使用量クォータ]
    end

    Profile --> Account
    Profile --> Preferences
    Profile --> Notifications
    Profile --> SSHKeys
    Profile --> GPGKeys
    Profile --> Password
    Profile --> TwoFactorAuth
    Profile --> AccessTokens
    Profile --> ActiveSessions
    Profile --> Emails
    Profile --> ChatNames
    Profile --> CommentTemplates
    Profile --> UsageQuotas
```

## 管理者画面フロー

```mermaid
flowchart TD
    subgraph 概要
        AdminDashboard[管理者ダッシュボード]
        SystemInfo[システム情報]
        HealthCheck[ヘルスチェック]
        BackgroundJobs[バックグラウンドジョブ]
    end

    subgraph ユーザー管理
        UserList[ユーザー一覧]
        UserNew[ユーザー新規作成]
        UserDetail[ユーザー詳細]
        UserEdit[ユーザー編集]
    end

    subgraph グループ・プロジェクト管理
        AdminGroups[グループ一覧]
        AdminProjects[プロジェクト一覧]
        AdminOrgs[組織一覧]
    end

    subgraph システム設定
        Applications[アプリケーション一覧]
        Runners[Runner一覧]
        Hooks[Webhook一覧]
        DeployKeys[デプロイキー一覧]
        Labels[ラベル一覧]
        Appearances[外見設定]
    end

    subgraph 監視・レポート
        AbuseReports[不正利用レポート]
        SpamLogs[スパムログ]
        Cohorts[コホート分析]
        UsageTrends[使用トレンド]
        DevOpsReport[DevOpsレポート]
    end

    AdminDashboard --> SystemInfo
    AdminDashboard --> HealthCheck
    AdminDashboard --> BackgroundJobs
    AdminDashboard --> UserList
    AdminDashboard --> AdminGroups
    AdminDashboard --> AdminProjects
    AdminDashboard --> AdminOrgs
    AdminDashboard --> Applications
    AdminDashboard --> Runners
    AdminDashboard --> Hooks
    AdminDashboard --> DeployKeys
    AdminDashboard --> Labels
    AdminDashboard --> Appearances
    AdminDashboard --> AbuseReports
    AdminDashboard --> SpamLogs
    AdminDashboard --> Cohorts
    AdminDashboard --> UsageTrends
    AdminDashboard --> DevOpsReport

    UserList --> UserNew
    UserList --> UserDetail
    UserDetail --> UserEdit
```

## インポートフロー

```mermaid
flowchart TD
    ImportStart[インポート開始] --> GitHub[GitHubインポート]
    ImportStart --> GitLab[GitLabインポート]
    ImportStart --> Gitea[Giteaインポート]
    ImportStart --> BitbucketServer[Bitbucket Serverインポート]
    ImportStart --> Bitbucket[Bitbucketインポート]
    ImportStart --> Manifest[Manifestインポート]
    ImportStart --> Fogbugz[Fogbugzインポート]
    ImportStart --> URL[URLインポート]
    ImportStart --> GitLabProject[GitLabプロジェクトインポート]
    ImportStart --> BulkImport[一括インポート]

    GitHub --> GitHubStatus[インポート状態]
    GitHubStatus --> ImportHistory[インポート履歴]

    Fogbugz --> FogbugzUserMap[ユーザーマッピング]
    FogbugzUserMap --> FogbugzStatus[インポート状態]

    BulkImport --> BulkImportStatus[一括インポート状態]
    BulkImportStatus --> BulkImportHistory[一括インポート履歴]
```

## 組織フロー

```mermaid
flowchart TD
    OrgList[組織一覧] --> OrgNew[組織新規作成]
    OrgList --> OrgDetail[組織詳細]

    OrgDetail --> OrgUsers[組織ユーザー]
    OrgDetail --> OrgGroupsProjects[グループ・プロジェクト]
    OrgDetail --> OrgActivity[アクティビティ]
    OrgDetail --> OrgSettings[組織設定]

    OrgGroupsProjects --> OrgGroupNew[グループ新規作成]
    OrgGroupsProjects --> OrgGroupEdit[グループ編集]
    OrgGroupsProjects --> OrgProjectEdit[プロジェクト編集]
```

## エラー画面フロー

```mermaid
flowchart TD
    AnyPage[任意の画面] -->|403| AccessDenied[アクセス拒否]
    AnyPage -->|404| NotFound[Not Found]
    AnyPage -->|503| ServiceUnavailable[サービス利用不可]
    AnyPage -->|409| Conflict[コンフリクト]
    AnyPage -->|412| PreconditionFailed[事前条件失敗]
    AnyPage -->|認証エラー| OmniAuthError[OmniauthError]
    AnyPage -->|エンコード| EncodingError[エンコーディングエラー]
    AnyPage -->|Git| GitNotFound[Git未検出]

    AccessDenied --> Login[ログイン画面]
    NotFound --> Dashboard[ダッシュボード]
```

---

## 凡例

- 四角形: 画面
- 菱形: 条件分岐
- 円形: 開始/終了点
- 矢印: 画面遷移方向

## 注記

1. 本図は主要な画面遷移を示しており、すべての遷移パターンを網羅していません
2. 各画面からはナビゲーションメニューを通じて他の主要画面へ遷移可能です
3. 認証が必要な画面では、未ログイン状態でアクセスするとログイン画面へリダイレクトされます
4. 権限不足の場合はアクセス拒否画面が表示されます
