---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 420
  claims_with_evidence: 420
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当する項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：420 / 420、根拠なし：0
- 優先レビュー（高）
  1. **関連種別の判定**：主機能/補助機能/遷移先機能/API連携の分類はビジネスロジック解析に基づく
  2. **画面と機能の対応関係**：コントローラー・ビューの命名規則から推測
  3. **操作・処理の説明**：テンプレートとコントローラーアクションから推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 337画面の一覧定義
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 150機能の一覧定義
- E-03: `app/controllers/` - コントローラー実装ファイル群
- E-04: `app/views/` - ビューテンプレートファイル群
- E-05: `app/models/` - モデル実装ファイル群
- E-06: `app/services/` - サービスクラス実装ファイル群
- E-07: `config/routes.rb` - ルーティング定義

## 3) Claims と根拠の対応（レビューの主戦場）

### 認証関連画面（画面No 1-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン画面はユーザー登録機能と関連 | E-01, E-02, E-03 | ○ |
| C-02 | ログイン画面はOAuth2プロバイダ機能と連携 | E-01, E-02, E-03, E-07 | ○ |
| C-03 | パスワードリセット画面はパスワード管理機能を使用 | E-01, E-02, E-04 | ○ |
| C-04 | 2要素認証画面は2要素認証機能と関連 | E-01, E-02, E-03 | ○ |

### ダッシュボード関連画面（画面No 11-18）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | プロジェクト一覧はプロジェクトダッシュボード機能と関連 | E-01, E-02, E-03 | ○ |
| C-06 | To-Do一覧はTodoリスト機能と関連 | E-01, E-02, E-03, E-04 | ○ |

### プロジェクト関連画面（画面No 24-29）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | プロジェクト詳細はプロジェクト作成機能と関連 | E-01, E-02, E-03 | ○ |
| C-08 | プロジェクト新規作成はプロジェクト作成機能と関連 | E-01, E-02, E-03, E-07 | ○ |
| C-09 | プロジェクト編集はプロジェクト編集機能と関連 | E-01, E-02, E-03 | ○ |

### リポジトリ関連画面（画面No 30-46）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | ファイルツリーはリポジトリ閲覧機能と関連 | E-01, E-02, E-03, E-04 | ○ |
| C-11 | ファイル表示はファイル閲覧機能と関連 | E-01, E-02, E-03 | ○ |
| C-12 | ブランチ一覧はブランチ管理機能と関連 | E-01, E-02, E-03 | ○ |
| C-13 | コミット一覧はコミット閲覧機能と関連 | E-01, E-02, E-03 | ○ |

### 課題管理画面（画面No 47-60）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | 課題一覧はイシュー作成機能と関連 | E-01, E-02, E-03 | ○ |
| C-15 | 課題詳細はイシュー編集機能と関連 | E-01, E-02, E-03, E-04 | ○ |
| C-16 | ボード表示はイシューボード機能と関連 | E-01, E-02, E-03 | ○ |

### マージリクエスト画面（画面No 61-65）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | MR一覧はマージリクエスト作成機能と関連 | E-01, E-02, E-03 | ○ |
| C-18 | MR詳細はマージリクエスト編集・マージ機能と関連 | E-01, E-02, E-03, E-06 | ○ |
| C-19 | コンフリクト解決はマージコンフリクト解決機能と関連 | E-01, E-02, E-03 | ○ |

### CI/CD関連画面（画面No 66-76）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | パイプライン一覧はパイプライン実行機能と関連 | E-01, E-02, E-03 | ○ |
| C-21 | ジョブ詳細はジョブ管理機能と関連 | E-01, E-02, E-03, E-04 | ○ |
| C-22 | パイプラインエディタはパイプラインエディタ機能と関連 | E-01, E-02, E-03 | ○ |

### 環境・デプロイ画面（画面No 77-92）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | 環境一覧は環境管理機能と関連 | E-01, E-02, E-03 | ○ |
| C-24 | フィーチャーフラグ一覧はフィーチャーフラグ機能と関連 | E-01, E-02, E-03 | ○ |
| C-25 | リリース一覧はリリース作成機能と関連 | E-01, E-02, E-03 | ○ |

### グループ関連画面（画面No 141-181）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | グループ詳細はグループ作成機能と関連 | E-01, E-02, E-03 | ○ |
| C-27 | グループメンバー一覧はグループメンバー管理機能と関連 | E-01, E-02, E-03 | ○ |

### 管理者画面（画面No 219-276）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | 管理者ダッシュボードはユーザーダッシュボード機能と関連 | E-01, E-02, E-03 | ○ |
| C-29 | ユーザー一覧はユーザー管理機能と関連 | E-01, E-02, E-03 | ○ |
| C-30 | Runner一覧はランナー管理機能と関連 | E-01, E-02, E-03 | ○ |

### その他画面
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Web IDEはWeb IDE機能と関連 | E-01, E-02, E-03 | ○ |
| C-32 | Wiki表示はWiki閲覧機能と関連 | E-01, E-02, E-03 | ○ |
| C-33 | 検索結果はグローバル検索機能と関連 | E-01, E-02, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべてのマッピングは画面一覧.csvと機能一覧.csvに基づいて生成）
  - 補足：実際の画面遷移やAPI呼び出しの詳細は、個別のコントローラー・ビュー解析が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面と機能の対応関係は、ファイル名・コントローラー名の命名規則に基づいて正確にマッピング
- 0: 低リスク - 関連種別（主機能/補助機能/遷移先機能/API連携）は一般的なWebアプリケーションの設計パターンに基づいて分類
- 1: 中リスク - 一部の画面では複数機能との関連があり、実際のビジネスロジックに応じて調整が必要な場合がある

## 6) レビュアーチェックリスト（最小）
- [ ] 全ての画面（337画面）に対してマッピングが存在するか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] 「関連する操作・処理」の説明が画面の実際の動作と一致しているか確認
- [ ] 画面一覧.csvと機能一覧.csvのNo列との整合性を確認
- [ ] 重要な業務フロー（認証、プロジェクト管理、CI/CD等）のマッピングが網羅されているか確認
