# 画面設計書 1-ログイン画面

## 概要

本ドキュメントは、GitLabのログイン画面の設計仕様を記載したものです。ユーザーがシステムにアクセスするための認証入口として機能する画面です。

### 本画面の処理概要

**業務上の目的・背景**：ログイン画面は、GitLabシステムへのアクセス制御を行うセキュリティ上最も重要な画面です。正規のユーザーのみがシステムにアクセスできるようにすることで、ソースコード、課題、CI/CDパイプラインなどの機密情報を保護します。また、LDAP、OAuth、Passkeyなど複数の認証方式に対応することで、企業の既存認証基盤との統合や、より安全な認証方式の利用を可能にしています。

**画面へのアクセス方法**：
- GitLabのルートURL（`/`）に未認証状態でアクセスした場合に自動リダイレクト
- ナビゲーションバーの「Sign in」リンクをクリック
- 直接 `/users/sign_in` URLにアクセス
- 認証が必要なページへのアクセス時に自動リダイレクト

**主要な操作・処理内容**：
1. ユーザー名またはメールアドレスとパスワードによる標準認証
2. LDAPサーバーを使用した企業認証（設定時）
3. OAuthプロバイダー（GitHub、Google、GitLab.com等）による外部認証
4. Passkeyによるパスワードレス認証
5. 2要素認証（2FA）が有効な場合の追加認証ステップへの遷移
6. 「Remember me」オプションによるセッション永続化
7. reCAPTCHAによるボット対策（ログイン失敗時に表示）

**画面遷移**：
- 遷移元：任意のページ（未認証時のリダイレクト）、ユーザー登録完了画面、パスワードリセット完了画面
- 遷移先：ダッシュボード（認証成功時）、2要素認証画面（2FA有効時）、パスワードリセット画面、ユーザー登録画面、アカウントロック解除画面

**権限による表示制御**：
- 未認証ユーザーのみがアクセス可能
- 認証済みユーザーがアクセスした場合はダッシュボードにリダイレクト
- LDAPが有効な場合はLDAPタブが表示される
- OAuthプロバイダーが設定されている場合は対応するボタンが表示される
- パスワード認証が無効化されている場合は標準ログインフォームが非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 76 | ユーザー登録 | 主機能 | ユーザー認証・ログイン処理の実行 |
| 88 | OAuth2プロバイダ | 補助機能 | OAuth2による外部認証プロバイダ連携 |
| 89 | OAuth2クライアント | 補助機能 | 外部OAuth2プロバイダでの認証処理 |
| 90 | LDAP認証 | 補助機能 | LDAPディレクトリサービスとの連携認証 |

## 画面種別

ログイン（認証）

## URL/ルーティング

| HTTPメソッド | URL | アクション |
|-------------|-----|----------|
| GET | `/users/sign_in` | ログイン画面表示 |
| POST | `/users/sign_in` | ログイン処理実行 |
| POST | `/users/passkeys/sign_in` | Passkey認証開始 |
| GET | `/users/auth/:provider/callback` | OAuthコールバック |

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| ユーザー名/メール | user[login] | string | Yes | 255 | ユーザー名またはプライマリメールアドレス |
| パスワード | user[password] | string | Yes | 128 | ユーザーパスワード |
| Remember me | user[remember_me] | boolean | No | - | セッション永続化オプション |
| reCAPTCHA | - | token | 条件付き | - | ログイン失敗時に必要 |

## 表示項目

| 項目名 | 説明 | 条件 |
|--------|------|------|
| ログインフォーム | 標準認証用フォーム | パスワード認証が有効時 |
| LDAPタブ | LDAP認証用タブ | LDAP設定時 |
| OAuthボタン | 外部認証プロバイダボタン | OAuth設定時 |
| Passkeyボタン | パスワードレス認証ボタン | Passkey機能有効時 |
| 利用規約リンク | 利用規約への同意文言 | 利用規約設定時 |
| 新規登録リンク | ユーザー登録画面へのリンク | サインアップ許可時 |
| パスワードリセットリンク | パスワードリセット画面へのリンク | 常時表示 |
| ブロードキャストメッセージ | 管理者からの告知 | メッセージ設定時 |

## イベント仕様

### 1-ログインボタン押下

**トリガー**: 「Sign in」ボタンクリック

**処理フロー**:
1. フォームバリデーション（クライアントサイド）
2. reCAPTCHA検証（表示時）
3. ユーザー検索（login パラメータ）
4. パスワード検証
5. 2FA有効確認
6. セッション作成
7. リダイレクト先決定

**成功時**: ダッシュボードまたは元のページにリダイレクト
**失敗時**: エラーメッセージを表示してログイン画面に戻る

### 2-OAuthボタン押下

**トリガー**: OAuth プロバイダボタンクリック

**処理フロー**:
1. OAuthプロバイダの認可エンドポイントにリダイレクト
2. ユーザーが外部サービスで認証
3. コールバックURLで認証コードを受信
4. アクセストークン取得
5. ユーザー情報取得・照合
6. セッション作成

### 3-Passkeyボタン押下

**トリガー**: 「Passkey」ボタンクリック

**処理フロー**:
1. WebAuthn認証チャレンジ生成
2. ブラウザのPasskey UI表示
3. ユーザーが生体認証等で承認
4. 認証レスポンス検証
5. セッション作成

### 4-Remember me チェック

**トリガー**: チェックボックス状態変更

**処理**: ログイン成功時のセッション有効期限を延長（デフォルト2週間）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログイン成功 | users | UPDATE | 最終ログイン情報更新 |
| ログイン成功 | users | UPDATE | reset_password_token クリア |
| ログイン成功 | authentication_events | INSERT | 認証イベント記録 |
| ログイン成功 | audit_events | INSERT | 監査ログ記録 |
| ログイン失敗 | users | UPDATE | failed_attempts カウント増加 |
| アカウントロック | users | UPDATE | locked_at 設定 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | sign_in_count | +1 | ログイン成功時 |
| UPDATE | current_sign_in_at | 現在時刻 | ログイン成功時 |
| UPDATE | last_sign_in_at | 旧current_sign_in_at | ログイン成功時 |
| UPDATE | current_sign_in_ip | リクエストIP | ログイン成功時 |
| UPDATE | last_sign_in_ip | 旧current_sign_in_ip | ログイン成功時 |
| UPDATE | reset_password_token | NULL | ログイン成功時（トークン存在時） |
| UPDATE | reset_password_sent_at | NULL | ログイン成功時（トークン存在時） |
| UPDATE | failed_attempts | +1 | ログイン失敗時 |
| UPDATE | locked_at | 現在時刻 | ロック閾値超過時 |

#### authentication_events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_id | 認証ユーザーID | - |
| INSERT | result | success/failed | 認証結果 |
| INSERT | ip_address | リクエストIP | - |
| INSERT | provider | standard/ldap/oauth | 認証方式 |
| INSERT | created_at | 現在時刻 | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|---------------|----------|
| MSG001 | エラー | Invalid login or password | 認証失敗時 |
| MSG002 | エラー | Your account is locked | アカウントロック時 |
| MSG003 | エラー | Your account is blocked | アカウントブロック時 |
| MSG004 | エラー | You have to confirm your email address | メール未確認時 |
| MSG005 | エラー | There was an error with the reCAPTCHA | reCAPTCHA失敗時 |
| MSG006 | 情報 | Welcome back! Your account had been deactivated... | 非アクティブアカウント再有効化時 |
| MSG007 | エラー | No authentication methods configured | 認証方式未設定時 |
| MSG008 | エラー | Password authentication is unavailable | パスワード認証無効時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| アカウントロック | ロック解除画面へのリンクを表示 |
| アカウントブロック | 管理者への連絡を促すメッセージを表示 |
| メール未確認 | 確認メール再送画面へのリンクを表示 |
| 2FA必須 | 2要素認証画面にリダイレクト |
| パスワード期限切れ | パスワード変更画面にリダイレクト |
| 初期セットアップ状態 | 管理者初期設定画面にリダイレクト |
| OAuthエラー | エラーメッセージを表示してログイン画面に戻る |

## 備考

- 最大5回のログイン失敗でreCAPTCHAが表示される
- 10回のログイン失敗でアカウントがロックされる（デフォルト設定）
- OAuthプロバイダは管理者設定で有効化される
- Passkey機能はフィーチャーフラグ `passkeys` で制御される
- LDAPサーバーは複数設定可能で、それぞれタブとして表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログイン処理で使用されるユーザーモデルとDeviseの認証設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | user.rb | `app/models/user.rb` | Deviseモジュールの設定（112-120行目）、認証関連属性 |

**読解のコツ**: Railsの `devise` DSLで宣言されたモジュール（`:two_factor_authenticatable`, `:lockable`, `:recoverable`等）がユーザー認証の挙動を決定する。

#### Step 2: エントリーポイントを理解する

リクエストを受け取るコントローラーの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sessions_controller.rb | `app/controllers/sessions_controller.rb` | new/createアクション、before_actionフィルター |

**主要処理フロー**:
1. **26-27行目**: `authenticate_with_two_factor` - 2FA有効ユーザーの認証処理
2. **28行目**: `check_captcha` - reCAPTCHA検証
3. **31-32行目**: `ensure_password_authentication_enabled!` - パスワード認証の有効性確認
4. **67-71行目**: `new` アクション - ログイン画面表示
5. **82-102行目**: `create` アクション - ログイン処理実行

#### Step 3: ビューテンプレートを理解する

画面の構成要素と表示条件を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/devise/sessions/new.html.haml` | 画面全体の構成、条件分岐 |
| 3-2 | _tabs_ldap.html.haml | `app/views/devise/shared/_tabs_ldap.html.haml` | LDAP/標準認証タブ切り替え |
| 3-3 | _new_base.html.haml | `app/views/devise/sessions/_new_base.html.haml` | 標準ログインフォーム |
| 3-4 | _omniauth_box.html.haml | `app/views/devise/shared/_omniauth_box.html.haml` | OAuthボタン表示 |

**主要処理フロー**:
- **new.html.haml 14-17行目**: LDAP有効時のタブ表示、パスワード認証のみの場合の標準フォーム表示
- **_new_base.html.haml 19-41行目**: ログインフォームの入力項目定義
- **_new_base.html.haml 43-46行目**: Passkeyボタンの条件付き表示

#### Step 4: 認証処理の詳細を理解する

Deviseの認証処理とGitLab固有の拡張を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | authenticates_with_two_factor.rb | `app/controllers/concerns/authenticates_with_two_factor.rb` | 2FA認証処理 |
| 4-2 | known_sign_in.rb | `app/controllers/concerns/known_sign_in.rb` | 既知デバイスからのログイン検証 |

### プログラム呼び出し階層図

```
SessionsController#create
    │
    ├─ check_captcha (before_action)
    │      └─ Gitlab::Recaptcha.load_configurations!
    │
    ├─ authenticate_with_two_factor (prepend_before_action)
    │      ├─ find_user
    │      ├─ valid_otp_attempt?
    │      │      └─ Users::ValidateManualOtpService
    │      └─ session[:otp_user_id] = user.id
    │
    ├─ Devise::SessionsController#create (super)
    │      ├─ warden.authenticate!
    │      │      └─ User.find_by_login
    │      └─ sign_in(resource)
    │
    ├─ log_audit_event
    │      └─ Gitlab::Audit::Auditor.audit
    │
    └─ log_user_activity
           └─ Users::ActivityService.new.execute
```

### データフロー図

```
[入力]                    [処理]                         [出力]

user[login]      ───▶ SessionsController#create ───▶ セッションCookie
user[password]          │
                        ├─ User.find_by_login ───▶ users テーブル SELECT
                        │
                        ├─ valid_password? ───▶ bcrypt検証
                        │
                        ├─ update_tracked_fields! ───▶ users テーブル UPDATE
                        │
                        └─ Auditor.audit ───▶ audit_events テーブル INSERT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sessions_controller.rb | `app/controllers/sessions_controller.rb` | コントローラー | ログイン処理の制御 |
| user.rb | `app/models/user.rb` | モデル | ユーザーデータと認証ロジック |
| new.html.haml | `app/views/devise/sessions/new.html.haml` | ビュー | ログイン画面テンプレート |
| _new_base.html.haml | `app/views/devise/sessions/_new_base.html.haml` | ビュー | 標準ログインフォーム |
| _tabs_ldap.html.haml | `app/views/devise/shared/_tabs_ldap.html.haml` | ビュー | LDAP/標準認証タブ |
| _omniauth_box.html.haml | `app/views/devise/shared/_omniauth_box.html.haml` | ビュー | OAuthボタン群 |
| authenticates_with_two_factor.rb | `app/controllers/concerns/authenticates_with_two_factor.rb` | Concern | 2FA認証処理 |
| user.rb (routes) | `config/routes/user.rb` | 設定 | ルーティング定義 |
| devise.rb | `config/initializers/devise.rb` | 設定 | Devise初期設定 |
