# 画面設計書 100-アラート管理

## 概要

本ドキュメントは、GitLabにおけるアラート管理画面の設計仕様を記述したものです。

### 本画面の処理概要

この画面では、プロジェクトに関連するアラートの一覧を表示・管理します。アラートは監視システムやCI/CDパイプラインから発生し、インシデント管理と連携してシステム運用における問題を追跡するために使用されます。

**業務上の目的・背景**：
DevOps/SREの実践において、システム監視から発生するアラートの一元管理は重要です。GitLabのアラート管理機能は、Prometheus、HTTP統合、その他の監視ツールからアラートを受信し、重大度によるフィルタリング、担当者へのアサイン、インシデントへの昇格を可能にします。本画面は、プロジェクト内のすべてのアラートを一覧表示し、ステータスの変更、インシデント作成への連携を行うための中心的なインターフェースを提供します。

**画面へのアクセス方法**：
1. プロジェクト画面から左側ナビゲーションの「モニタリング」セクションを展開
2. 「アラート」をクリック

**主要な操作・処理内容**：
1. アラート一覧の表示（ページネーション付き）
2. アラートの検索・フィルタリング（テキスト検索、担当者）
3. アラート詳細画面への遷移
4. アラートからインシデントの作成

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、モニタリングメニュー、通知
- 遷移先：アラート詳細画面、運用設定画面、インシデント作成画面

**権限による表示制御**：
- `read_alert_management_alert` 権限でアラートの閲覧が可能
- `admin_operations` 権限でアラート管理の有効化設定が可能
- `update_alert_management_alert` 権限でアラートの更新が可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 131 | アラート管理 | 主機能 | アラートの一覧・管理 |
| 45 | インシデント管理 | 遷移先機能 | アラートからインシデント作成 |

## 画面種別

一覧画面

## URL/ルーティング

- URL: `/:namespace_id/:project_id/-/alert_management`
- ルート定義: `config/routes/project.rb`
- コントローラー: `Projects::AlertManagementController#index`

## 入出力項目

### 入力項目（検索・フィルタリング）

| 項目名 | データ型 | 必須 | 説明 |
|--------|---------|------|------|
| search | String | いいえ | テキスト検索キーワード |
| assignee_username | String | いいえ | 担当者のユーザー名でフィルタ |

### 出力項目（表示データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| プロジェクトパス | String | プロジェクトのフルパス |
| アラート管理設定パス | String | 運用設定画面のURL |
| アラートヘルプURL | String | アラートに関するヘルプドキュメントURL |
| アラート統合設定ヘルプURL | String | アラート統合設定に関するヘルプドキュメントURL |
| 空状態イラストパス | String | アラートがない場合の画像パス |
| アラート管理有効化権限 | Boolean | アラート管理の有効化権限の有無 |
| アラート管理有効状態 | Boolean | アラート管理が有効かどうか |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| アラートタイトル | リンク | 詳細画面へのリンク |
| ステータス | バッジ | triggered/acknowledged/resolved状態 |
| 重大度 | バッジ | 重大度レベル（critical, high, medium, low, info, unknown） |
| 開始日時 | 日時 | アラート発生日時 |
| イベント数 | 数値 | 同一アラートのイベント数 |
| 担当者 | アバター+リンク | 担当者のプロフィールへのリンク |
| 監視ツール | テキスト | アラート発生元の監視ツール |
| サービス | テキスト | 関連するサービス名 |

## イベント仕様

### 1-アラート一覧表示

**処理フロー**：
1. 画面アクセス時にVue.jsコンポーネント（#js-alert_management）がマウント
2. alert_management_dataヘルパーでテンプレートデータを構築
3. GraphQL APIでアラート一覧を取得
4. 一覧を表示

### 2-アラート検索

**処理フロー**：
1. 検索フォームにキーワードを入力
2. GraphQL APIでアラートを検索
3. 検索結果を一覧に反映

### 3-アラート詳細へ遷移

**処理フロー**：
1. アラートタイトルをクリック
2. `/alert_management/:id` へ遷移
3. アラート詳細画面を表示

### 4-アラート管理有効化

**処理フロー**：
1. アラートが存在せず、管理未有効の場合は空状態画面を表示
2. 「アラート統合を設定」ボタンをクリック
3. 運用設定画面（アラート管理設定セクション）へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | alert_management_alerts | SELECT | アラート一覧の取得 |
| 画面表示 | alert_management_http_integrations | SELECT | 統合有効状態の確認 |

### テーブル別更新項目詳細

#### alert_management_alerts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, title, status, severity, started_at, events, etc. | project_id = 対象プロジェクト | 一覧表示用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|---------|
| MSG-001 | 情報 | No alerts to display | アラートが存在せず、統合が有効な場合 |
| MSG-002 | 情報 | Surface alerts in GitLab | アラートが存在せず、統合が未設定の場合（空状態） |
| MSG-003 | エラー | Access Denied | read_alert_management_alert権限なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| インシデント機能フラグ無効 | 404エラー画面を表示 |
| 権限不足 | 403 Access Denied画面を表示 |
| プロジェクト未存在 | 404エラー画面を表示 |

## 備考

- 本画面はVue.jsコンポーネント（`#js-alert_management`）で実装されている
- アラートはAlertManagement::Alertモデルで管理される
- IncidentManagementFeatureFlagでフィーチャーフラグ制御
- alert_management_enabled?でアラートまたはHTTP統合の存在を確認
- アラートの重大度は6段階：critical, high, medium, low, info, unknown
- アラートのステータスはEscalatableで管理（triggered, acknowledged, resolved）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アラートのデータ構造と関連データを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | alert.rb | `app/models/alert_management/alert.rb` | Alertモデル、ステータス、重大度、スコープ |
| 1-2 | http_integration.rb | `app/models/alert_management/http_integration.rb` | HTTP統合モデル |

**読解のコツ**: アラートはAlertManagement::Alertモデルで管理され、IncidentManagement::Escalatableをincludeしてステータス管理を行います。重大度（severity）は6段階、ステータス（status）は3段階で管理されています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | alert_management_controller.rb | `app/controllers/projects/alert_management_controller.rb` | indexアクションの処理 |

**主要処理フロー**:
1. **4行**: `include IncidentManagementFeatureFlag` - インシデント管理機能フラグ制御
2. **6行**: `authorize_read_alert_management_alert!` - 権限チェック
3. **7行**: `check_incidents_feature_flag` - フィーチャーフラグチェック
4. **12行**: `index`メソッド（空実装、ビューのみレンダリング）
5. **14-16行**: `details`メソッドで@alert_idを設定

#### Step 3: ヘルパーを理解する

フロントエンドに渡すデータ構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | alert_management_helper.rb | `app/helpers/projects/alert_management_helper.rb` | alert_management_dataメソッド |

**主要処理フロー**:
- **4-22行**: `alert_management_data`でテンプレートデータを構築
- **6行**: プロジェクトパスを設定
- **7-10行**: アラート管理設定画面へのパスを設定
- **17行**: `admin_operations`権限で有効化権限を判定
- **18行**: `alert_management_enabled?`でアラート管理有効状態を判定
- **24-34行**: `alert_management_detail_data`で詳細画面用データを構築
- **38-43行**: `alert_management_enabled?`でアラートまたはHTTP統合の存在を確認

#### Step 4: ビューテンプレートを理解する

表示の仕組みを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.html.haml | `app/views/projects/alert_management/index.html.haml` | Vue.jsコンポーネントのマウント |
| 4-2 | details.html.haml | `app/views/projects/alert_management/details.html.haml` | 詳細画面のテンプレート |

**主要処理フロー**:
- **1行**: `page_title _('Alerts')` - ページタイトル設定
- **2行**: `paginated_table`スタイルを読み込み
- **4行**: `#js-alert_management`にVue.jsコンポーネントをマウント

### プログラム呼び出し階層図

```
Projects::AlertManagementController#index
    │
    ├─ include IncidentManagementFeatureFlag
    │      └─ check_incidents_feature_flag
    │
    ├─ before_action: authorize_read_alert_management_alert!
    │      └─ can?(current_user, :read_alert_management_alert, @project)
    │
    └─ Render: index.html.haml
           │
           └─ alert_management_data(@current_user, @project)
                  ├─ project.full_path
                  ├─ project_settings_operations_path
                  ├─ help_page_url (alerts, integrations)
                  ├─ can?(current_user, :admin_operations, project)
                  └─ alert_management_enabled?(project)
                         ├─ project.alert_management_alerts.any?
                         └─ AlertManagement::HttpIntegrationsFinder
                                └─ active: true
```

### データフロー図

```
[入力]               [処理]                    [出力]

リクエスト ───▶ AlertManagementController#index ───▶ テンプレートデータ(JSON)
(params)                │                                  │
                        ├─ 権限チェック                    ├─ project-path
                        │                                  │
                        ├─ フラグチェック                  ├─ enable-alert-management-path
                        │                                  │
                        └─ ヘルパーでデータ構築            ├─ user-can-enable-alert-management
                                                           │
                                                           ├─ alert-management-enabled
                                                           │
                                                           └─ text-query, assignee-username-query
                                                           │
                                                           ▼
                                                     Vue.js Component
                                                     (#js-alert_management)
                                                           │
                                                           └─ GraphQL API
                                                                  │
                                                                  └─ alert_management_alerts テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html.haml | `app/views/projects/alert_management/index.html.haml` | テンプレート | 画面のHTMLテンプレート |
| details.html.haml | `app/views/projects/alert_management/details.html.haml` | テンプレート | 詳細画面のHTMLテンプレート |
| alert_management_controller.rb | `app/controllers/projects/alert_management_controller.rb` | コントローラー | 画面のメインコントローラー |
| alert_management_helper.rb | `app/helpers/projects/alert_management_helper.rb` | ヘルパー | テンプレートデータの構築 |
| alert.rb | `app/models/alert_management/alert.rb` | モデル | アラートのデータモデル |
| http_integration.rb | `app/models/alert_management/http_integration.rb` | モデル | HTTP統合のデータモデル |
| project.rb | `config/routes/project.rb` | ルーティング | URLルーティング定義（353-359行） |
