# 画面設計書 101-エラートラッキング

## 概要

本ドキュメントは、GitLabのエラートラッキング画面の設計仕様を定義するものです。

### 本画面の処理概要

エラートラッキング画面は、プロジェクト内で発生したアプリケーションエラーを一覧表示し、運用監視を行うための画面です。Sentryとの連携または統合エラートラッキング機能を利用して、アプリケーションから収集されたエラー情報をリアルタイムで監視・管理することができます。

**業務上の目的・背景**：アプリケーション運用において、本番環境で発生するエラーを迅速に検知し対応することは、サービス品質維持に不可欠です。本画面は、エラーの発生状況を一元管理し、エラーの重複排除、発生頻度の追跡、ステータス管理を通じて、運用チームの効率的なエラー対応を支援します。

**画面へのアクセス方法**：プロジェクトのサイドナビゲーションから「モニター」>「エラートラッキング」を選択してアクセスします。

**主要な操作・処理内容**：
1. エラー一覧の表示とフィルタリング（検索語、ステータス、ソート順）
2. エラーの詳細表示への遷移
3. エラーステータスの更新（解決済み、無視など）
4. ポーリングによるリアルタイム更新

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、運用設定画面
- 遷移先：エラー詳細画面、運用設定画面（エラートラッキング有効化）

**権限による表示制御**：
- `read_sentry_issue`権限：エラー一覧の閲覧に必要
- `update_sentry_issue`権限：エラーステータス更新に必要
- `admin_operations`権限：エラートラッキング設定の有効化リンク表示に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 132 | エラートラッキング | 主機能 | エラートラッキングの一覧表示 |
| 131 | アラート管理 | 補助機能 | アラートとの連携 |

## 画面種別

一覧

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/error_tracking
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| search_term | 入力 | String | - | エラー検索キーワード |
| sort | 入力 | String | - | ソート順（frequency, first_seen, last_seen） |
| cursor | 入力 | String | - | ページネーション用カーソル |
| issue_status | 入力 | String | - | エラーステータスフィルター（unresolved, resolved, ignored） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| エラータイトル | String | エラーの概要・メッセージ |
| エラーカウント | Integer | エラー発生回数 |
| ユーザー影響数 | Integer | 影響を受けたユーザー数 |
| 初回発生日時 | DateTime | エラーが初めて発生した日時 |
| 最終発生日時 | DateTime | エラーが最後に発生した日時 |
| ステータス | String | エラーの現在のステータス |
| 外部URL | String | Sentryなど外部サービスへのリンク |

## イベント仕様

### 1-検索実行

検索フォームに入力後、エラー一覧がフィルタリングされて再表示されます。APIへ非同期リクエストが送信され、結果がJSON形式で返却されます。

### 2-ステータス変更

エラーのステータスを変更すると、`ErrorTracking::IssueUpdateService`が呼び出され、Sentryまたは統合エラートラッキングのデータが更新されます。

### 3-自動ポーリング

一定間隔でAPIへリクエストを送信し、新しいエラーの有無を確認します。ポーリング間隔はレスポンスヘッダーで制御されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | error_tracking_errors | SELECT | エラー一覧の取得（統合モード時） |
| ステータス変更 | error_tracking_errors | UPDATE | エラーステータスの更新（統合モード時） |

### テーブル別更新項目詳細

#### error_tracking_errors（統合エラートラッキング使用時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | status | 指定されたステータス値 | Sentry連携時は外部API経由 |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 情報 | - | Error tracking is not enabled. |
| エラー | - | Failed to load errors. Please try again. |
| 成功 | - | Error status updated successfully. |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| エラートラッキング未設定 | 設定画面へのリンクを含む案内メッセージを表示 |
| Sentry API エラー | エラーメッセージを表示し、リトライを促す |
| 権限不足 | 404エラーを返却 |
| フィーチャーフラグ無効 | 404エラーを返却 |

## 備考

- 統合エラートラッキング機能は`integrated_error_tracking`フィーチャーフラグで制御されています
- Sentry連携と統合エラートラッキングの両方をサポートしていますが、同時に使用することはできません
- エラー詳細画面への遷移は別ルート（`/:issue_id/details`）で処理されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エラートラッキングで扱うデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project_error_tracking_setting.rb | `app/models/error_tracking/project_error_tracking_setting.rb` | エラートラッキング設定モデル。Sentry連携と統合モードの切り替えロジックを理解する |
| 1-2 | error.rb | `app/models/error_tracking/error.rb` | エラーエンティティの構造を理解する |

**読解のコツ**: `sentry_enabled`と`integrated_client?`メソッドで、どちらのモードが有効かを判定しています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | error_tracking_controller.rb | `app/controllers/projects/error_tracking_controller.rb` | indexアクションがエントリーポイント。HTML/JSON両方に対応 |

**主要処理フロー**:
1. **行15-23**: indexアクション。format.htmlで画面表示、format.jsonでAPI応答
2. **行48-63**: render_index_json。ListIssuesServiceを呼び出しエラー一覧を取得
3. **行35-44**: updateアクション。IssueUpdateServiceでステータス更新

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/error_tracking/index.html.haml` | Vueコンポーネントをマウントするシンプルなテンプレート |
| 3-2 | error_tracking_helper.rb | `app/helpers/projects/error_tracking_helper.rb` | フロントエンドに渡すデータ属性を生成 |

**主要処理フロー**:
- **行4-17**: error_tracking_dataメソッドでVueコンポーネントに必要なデータを準備

#### Step 4: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | list_issues_service.rb | `app/services/error_tracking/list_issues_service.rb` | エラー一覧取得ロジック |
| 4-2 | issue_update_service.rb | `app/services/error_tracking/issue_update_service.rb` | ステータス更新ロジック |

### プログラム呼び出し階層図

```
ErrorTrackingController#index
    │
    ├─ format.html
    │      └─ error_tracking_data (Helper)
    │             └─ project.error_tracking_setting
    │
    └─ format.json
           └─ ErrorTracking::ListIssuesService#execute
                  ├─ Sentry連携時: SentryClient#list_issues
                  └─ 統合モード時: ErrorTracking::Error.where(...)
```

### データフロー図

```
[入力]                     [処理]                           [出力]

ブラウザリクエスト ───▶ ErrorTrackingController ───▶ HTML/JSON レスポンス
                              │
                              ▼
                      ListIssuesService
                              │
              ┌───────────────┴───────────────┐
              ▼                               ▼
       Sentry API                   ErrorTracking::Error
       (外部連携)                      (統合モード)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| error_tracking_controller.rb | `app/controllers/projects/error_tracking_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| index.html.haml | `app/views/projects/error_tracking/index.html.haml` | ビュー | 画面テンプレート |
| error_tracking_helper.rb | `app/helpers/projects/error_tracking_helper.rb` | ヘルパー | ビューヘルパー関数 |
| project_error_tracking_setting.rb | `app/models/error_tracking/project_error_tracking_setting.rb` | モデル | 設定データモデル |
| list_issues_service.rb | `app/services/error_tracking/list_issues_service.rb` | サービス | エラー一覧取得ロジック |
| issue_update_service.rb | `app/services/error_tracking/issue_update_service.rb` | サービス | ステータス更新ロジック |
| error_serializer.rb | `app/serializers/error_tracking/error_serializer.rb` | シリアライザ | JSONレスポンス整形 |
