# 画面設計書 102-サイクルアナリティクス

## 概要

本ドキュメントは、GitLabのサイクルアナリティクス（Value Stream Analytics）画面の設計仕様を定義するものです。

### 本画面の処理概要

サイクルアナリティクス画面は、プロジェクトの開発サイクルにおける各ステージの所要時間を可視化し、開発プロセスのボトルネックを特定するための分析画面です。イシュー作成からプロダクションデプロイまでの開発ライフサイクル全体を追跡し、チームの開発効率を測定・改善するためのインサイトを提供します。

**業務上の目的・背景**：DevOps実践において、開発サイクルの各フェーズでどれだけの時間がかかっているかを把握することは、継続的な改善（CI/CD）に不可欠です。本画面は、Issue、Plan、Code、Test、Review、Staging、Productionの各ステージにおける平均所要時間を計測し、チームがプロセス改善の優先度を判断するためのデータドリブンな意思決定を支援します。

**画面へのアクセス方法**：プロジェクトのサイドナビゲーションから「アナリティクス」>「Value stream analytics」を選択してアクセスします。旧パス`/cycle_analytics`からは自動的にリダイレクトされます。

**主要な操作・処理内容**：
1. 各ステージ（Issue、Plan、Code、Test、Review、Staging、Production）の平均所要時間表示
2. 期間フィルタリングによる分析対象期間の指定
3. サマリー統計（総イシュー数、総コミット数、総デプロイ数）の表示
4. 各ステージの詳細イベント一覧の表示

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、アナリティクスメニュー
- 遷移先：各ステージのイベント詳細（イシュー、マージリクエスト等）

**権限による表示制御**：
- `read_cycle_analytics`権限：画面閲覧に必要
- ライセンス機能`cycle_analytics_for_projects`：プロジェクトレベルの詳細分析に必要
- ライセンス機能`group_level_analytics_dashboard`：グループレベル分析ダッシュボードとの連携

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 128 | バリューストリームアナリティクス | 主機能 | 開発サイクル時間の分析表示 |
| 127 | CI/CDアナリティクス | 補助機能 | CI/CD関連メトリクスとの連携 |

## 画面種別

詳細（分析ダッシュボード）

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/value_stream_analytics
```

旧パスからのリダイレクト：
```
GET /:namespace_id/:project_id/-/cycle_analytics → リダイレクト
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| created_after | 入力 | Date | - | 分析対象期間の開始日 |
| created_before | 入力 | Date | - | 分析対象期間の終了日 |
| project_ids | 入力 | Array[Integer] | - | 分析対象プロジェクトID（複数選択可） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Issue | Duration | イシュー作成から開発着手までの平均時間 |
| Plan | Duration | 開発計画から最初のコミットまでの平均時間 |
| Code | Duration | 最初のコミットからMR作成までの平均時間 |
| Test | Duration | CI/CDパイプライン実行の平均時間 |
| Review | Duration | コードレビューの平均時間 |
| Staging | Duration | ステージング環境へのデプロイ平均時間 |
| Production | Duration | 本番環境へのデプロイ平均時間 |
| New Issues | Integer | 期間内に作成されたイシュー数 |
| Commits | Integer | 期間内のコミット数 |
| Deploys | Integer | 期間内のデプロイ数 |

## イベント仕様

### 1-期間フィルター変更

期間フィルターを変更すると、指定された期間のデータを再取得してグラフと統計を更新します。

### 2-ステージ詳細表示

各ステージをクリックすると、そのステージに含まれるイベント（イシュー、MRなど）の一覧がAPIから取得されます。

### 3-内部イベント追跡

画面表示時に`view_cycle_analytics`内部イベントがトラッキングされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | analytics_cycle_analytics_* | SELECT | 各種アナリティクスデータの取得 |
| イベント追跡 | internal_events | INSERT | 使用状況トラッキング |

### テーブル別更新項目詳細

本画面は主に参照系操作であり、直接的なデータ更新は発生しません。内部イベント追跡のみが記録されます。

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 情報 | - | No data available for this stage |
| 情報 | - | Not enough data |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データ不足 | ステージごとに「データ不足」メッセージを表示 |
| 権限不足 | 404エラーを返却 |
| タイムアウト | GracefulTimeoutHandlingによる適切なエラー表示 |

## 備考

- `p_analytics_valuestream`イベントとしてRedis HLLとSnowplowでトラッキングされます
- プロジェクトがライセンス機能を持つ場合、追加の分析機能が利用可能になります
- Value Streamはデフォルト値が自動生成されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、サイクルアナリティクスで扱うデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | value_stream.rb | `app/models/analytics/cycle_analytics/value_stream.rb` | バリューストリームの概念を理解する |
| 1-2 | project_level.rb | `lib/gitlab/analytics/cycle_analytics/project_level.rb` | プロジェクトレベルの分析ロジック |

**読解のコツ**: バリューストリームは複数のステージで構成され、各ステージは開発プロセスの特定フェーズを表します。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cycle_analytics_controller.rb | `app/controllers/projects/cycle_analytics_controller.rb` | showアクションがエントリーポイント |

**主要処理フロー**:
1. **行12**: `authorize_read_cycle_analytics!`で権限チェック
2. **行33-49**: showアクション。Analytics::CycleAnalytics::ProjectLevelを生成
3. **行34-37**: @cycle_analyticsインスタンス生成
4. **行38**: RequestParamsでリクエストパラメータを処理
5. **行42**: `Gitlab::InternalEvents.track_event`でイベント追跡

#### Step 3: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/cycle_analytics/show.html.haml` | Vueコンポーネントをマウントするテンプレート |

**主要処理フロー**:
- **行5**: `#js-cycle-analytics`にdata属性を設定してVueコンポーネントをマウント

#### Step 4: パラメータ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | request_params.rb | `lib/gitlab/analytics/cycle_analytics/request_params.rb` | リクエストパラメータの検証とフォーマット |
| 4-2 | cycle_analytics_params.rb | `app/controllers/concerns/cycle_analytics_params.rb` | コントローラで使用されるパラメータ関連メソッド |

### プログラム呼び出し階層図

```
CycleAnalyticsController#show
    │
    ├─ authorize_read_cycle_analytics!
    │
    ├─ Analytics::CycleAnalytics::ProjectLevel.new
    │      │
    │      ├─ summary (イシュー数、コミット数、デプロイ数)
    │      ├─ stats (各ステージの統計)
    │      └─ permissions
    │
    ├─ RequestParams.new (パラメータ検証)
    │
    └─ Gitlab::InternalEvents.track_event
           └─ 'view_cycle_analytics'
```

### データフロー図

```
[入力]                     [処理]                           [出力]

期間パラメータ ───▶ CycleAnalyticsController ───▶ HTML/JSON レスポンス
                              │
                              ▼
                      ProjectLevel#summary
                              │
                              ▼
              ┌───────────────┴───────────────┐
              ▼                               ▼
        イシュー集計                    デプロイ集計
        コミット集計                    ステージ統計
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cycle_analytics_controller.rb | `app/controllers/projects/cycle_analytics_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| show.html.haml | `app/views/projects/cycle_analytics/show.html.haml` | ビュー | 画面テンプレート |
| project_level.rb | `lib/gitlab/analytics/cycle_analytics/project_level.rb` | ライブラリ | プロジェクトレベル分析ロジック |
| value_stream.rb | `app/models/analytics/cycle_analytics/value_stream.rb` | モデル | バリューストリームデータモデル |
| request_params.rb | `lib/gitlab/analytics/cycle_analytics/request_params.rb` | ライブラリ | パラメータ処理 |
| cycle_analytics_params.rb | `app/controllers/concerns/cycle_analytics_params.rb` | コンサーン | パラメータ関連メソッド |
| graceful_timeout_handling.rb | `app/controllers/concerns/graceful_timeout_handling.rb` | コンサーン | タイムアウト処理 |
