# 画面設計書 103-実験一覧

## 概要

本ドキュメントは、GitLabの機械学習実験一覧画面の設計仕様を定義するものです。

### 本画面の処理概要

ML実験一覧画面は、プロジェクト内で実行された機械学習実験（Experiments）を一覧表示し、MLOps運用を支援するための画面です。MLflowとの互換性を持ち、実験の追跡・管理・比較を行うための中心的なインターフェースを提供します。

**業務上の目的・背景**：機械学習プロジェクトにおいて、複数の実験を体系的に管理し、各実験の結果を比較することは、最適なモデルを見つけるために不可欠です。本画面は、MLflowプロトコルと互換性のある実験追跡機能を提供し、データサイエンティストがGitLab内でシームレスにMLワークフローを実行できる環境を構築します。

**画面へのアクセス方法**：プロジェクトのサイドナビゲーションから「分析」>「モデル実験」を選択してアクセスします。

**主要な操作・処理内容**：
1. プロジェクト内のML実験一覧表示
2. 実験詳細画面への遷移
3. 実験の削除（write権限保持者のみ）
4. MLflow Tracking URLの参照

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、アナリティクスメニュー
- 遷移先：実験詳細画面、モデルレジストリ

**権限による表示制御**：
- `read_model_experiments`権限：画面閲覧に必要
- `write_model_experiments`権限：実験削除に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 135 | MLモデルレジストリ | 主機能 | ML実験の一覧表示 |

## 画面種別

一覧

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/ml/experiments
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| - | - | - | - | 本画面は入力パラメータを受け取りません |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 実験名 | String | 実験の識別名 |
| 候補数 | Integer | 実験に含まれる候補（Run）の数 |
| 作成日時 | DateTime | 実験が作成された日時 |
| 作成者 | User | 実験を作成したユーザー |

## イベント仕様

### 1-実験詳細表示

実験行をクリックすると、該当実験の詳細画面（候補一覧）に遷移します。

### 2-実験削除

削除ボタンをクリックすると、確認後に実験が削除されます。モデルに関連付けられた実験は削除できません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | ml_experiments | SELECT | 実験一覧の取得 |
| 実験削除 | ml_experiments | DELETE | 実験の削除 |
| 実験削除 | ml_candidates | DELETE | 関連候補の削除（CASCADE） |

### テーブル別更新項目詳細

#### ml_experiments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | project_id | 現在のプロジェクトID | 一覧取得条件 |
| DELETE | id | 指定された実験ID | モデル関連なしの場合のみ |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 成功 | - | Experiment removed |
| 情報 | - | No experiments found |
| エラー | - | Cannot delete an experiment associated to a model |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 404エラーを返却 |
| モデル関連実験の削除試行 | エラーメッセージ表示、削除中止 |

## 備考

- MLflowプロトコルと互換性があり、MLflow Tracking URLを使用して外部からログを送信可能
- 実験はモデルに関連付けることができ、関連付けられた実験は削除できません
- `feature_category :mlops`に分類されています

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ML実験で扱うデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | experiment.rb | `app/models/ml/experiment.rb` | 実験エンティティの構造、バリデーション、スコープを理解する |
| 1-2 | candidate.rb | `app/models/ml/candidate.rb` | 候補（Run）との関係を理解する |

**読解のコツ**: `has_many :candidates`の関連と、`model_id`によるモデル連携を確認。`stop_destroy`メソッドでモデル関連実験の削除防止ロジックを確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | experiments_controller.rb | `app/controllers/projects/ml/experiments_controller.rb` | indexアクションがエントリーポイント |

**主要処理フロー**:
1. **行8**: `check_read`で`read_model_experiments`権限チェック
2. **行16**: indexアクション（空メソッド - ビューに処理委譲）
3. **行41-44**: destroyアクション - 実験削除処理

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/ml/experiments/index.html.haml` | Vueコンポーネントをマウントするテンプレート |
| 3-2 | mlflow_helper.rb | `app/helpers/projects/ml/mlflow_helper.rb` | MLflow Tracking URL生成ロジック |

**主要処理フロー**:
- **行4-8**: `#js-project-ml-experiments-index`にdata属性を設定
- **mlflow_tracking_url**: MLflow互換APIのURLを生成

### プログラム呼び出し階層図

```
ExperimentsController#index
    │
    ├─ check_read (権限チェック)
    │      └─ can?(current_user, :read_model_experiments, @project)
    │
    └─ render index.html.haml
           │
           └─ mlflow_tracking_url (Helper)
                  └─ API URL生成

ExperimentsController#destroy
    │
    ├─ check_write (権限チェック)
    │
    ├─ set_experiment
    │      └─ Ml::Experiment.by_project_id_and_iid
    │
    └─ @experiment.destroy
           └─ stop_destroy (モデル関連チェック)
```

### データフロー図

```
[入力]                     [処理]                           [出力]

ブラウザリクエスト ───▶ ExperimentsController ───▶ HTML レスポンス
                              │
                              ▼
                      Ml::Experiment.all
                              │
                              ▼
              ┌───────────────┴───────────────┐
              ▼                               ▼
        Vue Component                   MLflow API
        (フロントエンド)               (外部連携URL)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| experiments_controller.rb | `app/controllers/projects/ml/experiments_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| index.html.haml | `app/views/projects/ml/experiments/index.html.haml` | ビュー | 画面テンプレート |
| experiment.rb | `app/models/ml/experiment.rb` | モデル | 実験データモデル |
| candidate.rb | `app/models/ml/candidate.rb` | モデル | 候補データモデル |
| mlflow_helper.rb | `app/helpers/projects/ml/mlflow_helper.rb` | ヘルパー | MLflow URL生成 |
| experiments_helper.rb | `app/helpers/projects/ml/experiments_helper.rb` | ヘルパー | 実験関連ビューヘルパー |
