# 画面設計書 104-実験詳細

## 概要

本ドキュメントは、GitLabの機械学習実験詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

ML実験詳細画面は、特定の機械学習実験に含まれる候補（Run/Candidate）の一覧を表示し、各候補のメトリクス・パラメータを比較するための画面です。実験結果の詳細分析とモデル選定を支援する中心的な機能を提供します。

**業務上の目的・背景**：機械学習プロジェクトでは、ハイパーパラメータの異なる複数のモデル学習（候補）を実行し、その結果を比較してベストなモデルを選定する必要があります。本画面は、各候補のメトリクス値とパラメータ設定を一覧形式で表示し、ソート・フィルタリングによる効率的な比較分析を可能にします。

**画面へのアクセス方法**：実験一覧画面から特定の実験を選択、または直接URLでアクセスします。

**主要な操作・処理内容**：
1. 候補（Run）一覧の表示とページネーション
2. メトリクス・パラメータによるソート
3. 候補詳細画面への遷移
4. CSV形式でのエクスポート
5. 実験の削除（write権限保持者のみ）

**画面遷移**：
- 遷移元：実験一覧画面
- 遷移先：候補詳細画面、アーティファクト（パッケージ）画面

**権限による表示制御**：
- `read_model_experiments`権限：画面閲覧に必要
- `write_model_experiments`権限：実験削除に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 135 | MLモデルレジストリ | 主機能 | ML実験の詳細表示 |

## 画面種別

詳細（一覧含む）

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/ml/experiments/:iid
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| iid | 入力 | Integer | 必須 | 実験の内部ID |
| name | 入力 | String | - | 候補名でフィルター |
| order_by | 入力 | String | - | ソート対象カラム |
| sort | 入力 | String | - | ソート順（asc/desc） |
| order_by_type | 入力 | String | - | ソート種別（column/metric） |
| cursor | 入力 | String | - | ページネーション用カーソル |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 候補名 | String | 候補の識別名 |
| ステータス | Enum | 実行状態（running, scheduled, finished, failed, killed） |
| パラメータ | Hash | ログされたパラメータ一覧 |
| メトリクス | Hash | ログされたメトリクス一覧（最新値） |
| CI Job | Link | 関連するCI/CDジョブへのリンク |
| アーティファクト | Link | 関連パッケージへのリンク |
| 作成日時 | DateTime | 候補が作成された日時 |
| 作成者 | User | 候補を作成したユーザー |

## イベント仕様

### 1-候補詳細表示

候補行をクリックすると、該当候補の詳細画面に遷移します。

### 2-ソート実行

カラムヘッダーをクリックすると、該当カラムでソートが実行されます。メトリクスカラムの場合は`order_by_type=metric`となります。

### 3-CSVエクスポート

エクスポートボタンをクリックすると、全候補のデータがCSV形式でダウンロードされます。

### 4-ページネーション

30件ごとのキーセットページネーションで、前後ページへの移動が可能です。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | ml_experiments | SELECT | 実験情報の取得 |
| 一覧表示 | ml_candidates | SELECT | 候補一覧の取得 |
| 一覧表示 | ml_candidate_metrics | SELECT | メトリクスの取得 |
| 一覧表示 | ml_candidate_params | SELECT | パラメータの取得 |

### テーブル別更新項目詳細

本画面は主に参照系操作であり、直接的なデータ更新は発生しません。

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 成功 | - | Experiment removed |
| 情報 | - | No candidates found |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 実験が見つからない | 404エラーを返却 |
| 権限不足 | 404エラーを返却 |

## 備考

- 1ページあたり最大30候補を表示（MAX_CANDIDATES_PER_PAGE）
- キーセットページネーションを使用し、大量データでも効率的にページング可能
- CSV出力時は全候補データが出力されます（ページネーションなし）
- `can_write_model_experiments`フラグがフロントエンドに渡され、編集可否を制御

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、実験と候補のデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | experiment.rb | `app/models/ml/experiment.rb` | 実験エンティティと候補との関連を理解する |
| 1-2 | candidate.rb | `app/models/ml/candidate.rb` | 候補のステータス、メトリクス、パラメータ関連を理解する |
| 1-3 | candidate_metric.rb | `app/models/ml/candidate_metric.rb` | メトリクスの構造を理解する |
| 1-4 | candidate_param.rb | `app/models/ml/candidate_param.rb` | パラメータの構造を理解する |

**読解のコツ**: Candidateモデルの`latest_metrics`スコープと`order_by_metric`スコープを確認。メトリクスでのソートロジックを理解。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | experiments_controller.rb | `app/controllers/projects/ml/experiments_controller.rb` | showアクションがエントリーポイント |

**主要処理フロー**:
1. **行8**: `check_read`で権限チェック
2. **行10**: `set_experiment`で実験をロード
3. **行18-38**: showアクション - CandidateFinder使用、CSV/HTML両形式対応
4. **行23**: CandidateFinder.new - パラメータベースの検索
5. **行33**: keyset_paginate - ページネーション処理

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/ml/experiments/show.html.haml` | Vueコンポーネントへのデータ渡し |
| 3-2 | experiments_helper.rb | `app/helpers/projects/ml/experiments_helper.rb` | データ整形ロジック |

**主要処理フロー**:
- **行6-10**: ヘルパー関数でデータ整形
- **行12-21**: Vueコンポーネントにdata属性を設定

#### Step 4: データ検索とページネーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | candidate_finder.rb | `app/finders/ml/candidate_finder.rb` | 候補検索ロジック |

### プログラム呼び出し階層図

```
ExperimentsController#show
    │
    ├─ check_read (権限チェック)
    │
    ├─ set_experiment
    │      └─ Ml::Experiment.by_project_id_and_iid
    │
    ├─ format.csv
    │      └─ CandidatesCsvPresenter.new
    │             └─ finder.execute
    │
    └─ format.html
           ├─ CandidateFinder.new
           │      └─ finder.execute.keyset_paginate
           │
           └─ render show.html.haml
                  ├─ experiment_as_data (Helper)
                  ├─ candidates_table_items (Helper)
                  ├─ unique_logged_names (Helper)
                  └─ formatted_page_info (Helper)
```

### データフロー図

```
[入力]                     [処理]                           [出力]

iid, params ────▶ ExperimentsController ────▶ HTML/CSV レスポンス
                              │
                              ▼
                      CandidateFinder
                              │
                              ▼
              ┌───────────────┴───────────────┐
              ▼                               ▼
        Ml::Candidate                   keyset_paginate
        (with metrics/params)           (ページング)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| experiments_controller.rb | `app/controllers/projects/ml/experiments_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| show.html.haml | `app/views/projects/ml/experiments/show.html.haml` | ビュー | 画面テンプレート |
| experiments_helper.rb | `app/helpers/projects/ml/experiments_helper.rb` | ヘルパー | データ整形関数 |
| experiment.rb | `app/models/ml/experiment.rb` | モデル | 実験データモデル |
| candidate.rb | `app/models/ml/candidate.rb` | モデル | 候補データモデル |
| candidate_metric.rb | `app/models/ml/candidate_metric.rb` | モデル | メトリクスデータモデル |
| candidate_param.rb | `app/models/ml/candidate_param.rb` | モデル | パラメータデータモデル |
| candidate_finder.rb | `app/finders/ml/candidate_finder.rb` | Finder | 候補検索ロジック |
| candidates_csv_presenter.rb | `app/presenters/ml/candidates_csv_presenter.rb` | プレゼンター | CSVエクスポート用データ整形 |
