# 画面設計書 105-モデル一覧

## 概要

本ドキュメントは、GitLabのMLモデルレジストリ一覧画面の設計仕様を定義するものです。

### 本画面の処理概要

モデル一覧画面は、プロジェクト内に登録されたMLモデルを一覧表示し、モデルレジストリを管理するための画面です。モデルのバージョン管理、メタデータ管理を行い、MLOpsにおけるモデルライフサイクル管理を支援します。

**業務上の目的・背景**：機械学習プロジェクトにおいて、学習済みモデルを体系的に管理し、バージョン管理を行うことは、本番運用とモデルの再現性確保に不可欠です。本画面は、MLモデルのレジストリ機能を提供し、モデルの作成・バージョニング・メタデータ管理を一元化します。

**画面へのアクセス方法**：プロジェクトのサイドナビゲーションから「デプロイ」>「モデルレジストリ」を選択してアクセスします。

**主要な操作・処理内容**：
1. プロジェクト内のMLモデル一覧表示
2. モデル新規作成画面への遷移
3. モデル詳細画面への遷移
4. MLflow Tracking URLの参照

**画面遷移**：
- 遷移元：プロジェクトダッシュボード、デプロイメニュー
- 遷移先：モデル詳細画面、モデル新規作成画面

**権限による表示制御**：
- `read_model_registry`権限：画面閲覧に必要
- `write_model_registry`権限：モデル作成に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 135 | MLモデルレジストリ | 主機能 | MLモデルの一覧表示 |

## 画面種別

一覧

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/ml/models
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| - | - | - | - | 本画面は入力パラメータを受け取りません |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| モデル名 | String | モデルの識別名 |
| バージョン数 | Integer | モデルに含まれるバージョンの数 |
| 最新バージョン | String | 最新のバージョン番号 |
| 作成日時 | DateTime | モデルが作成された日時 |

## イベント仕様

### 1-モデル詳細表示

モデル行をクリックすると、該当モデルの詳細画面に遷移します。

### 2-モデル新規作成

「新規モデル作成」ボタンをクリックすると、モデル新規作成画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | ml_models | SELECT | モデル一覧の取得 |
| 一覧表示 | ml_model_versions | SELECT | バージョン数・最新バージョンの取得 |

### テーブル別更新項目詳細

本画面は主に参照系操作であり、直接的なデータ更新は発生しません。

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 情報 | - | No models found |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 404エラーを返却 |

## 備考

- モデル名は`Gitlab::Regex.ml_model_name_regex`で検証され、特定の命名規則に従う必要があります
- 最大ファイルサイズ制限は`project.actual_limits.ml_model_max_file_size`で設定されます
- MLflow Tracking URLを使用して外部からモデルを登録可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、MLモデルで扱うデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | model.rb | `app/models/ml/model.rb` | モデルエンティティの構造、バリデーション、スコープを理解する |
| 1-2 | model_version.rb | `app/models/ml/model_version.rb` | バージョンとの関係を理解する |

**読解のコツ**: `has_many :versions`と`has_one :latest_version`の関連を確認。`with_version_count`スコープでバージョン数を効率的に取得する方法を確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | models_controller.rb | `app/controllers/projects/ml/models_controller.rb` | indexアクションがエントリーポイント |

**主要処理フロー**:
1. **行6**: `authorize_read_model_registry!`で権限チェック
2. **行13**: indexアクション（空メソッド - ビューに処理委譲）

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html.haml | `app/views/projects/ml/models/index.html.haml` | Vueコンポーネントをマウントするテンプレート |
| 3-2 | model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | index_ml_model_data関数でデータ整形 |

**主要処理フロー**:
- **行4**: `#js-index-ml-models`にdata属性を設定
- **行8-18**: index_ml_model_dataでVueコンポーネント用データ生成

### プログラム呼び出し階層図

```
ModelsController#index
    │
    ├─ authorize_read_model_registry! (権限チェック)
    │      └─ can?(current_user, :read_model_registry, @project)
    │
    └─ render index.html.haml
           │
           └─ index_ml_model_data (Helper)
                  ├─ project.full_path
                  ├─ new_project_ml_model_path
                  ├─ can_write_model_registry?
                  ├─ mlflow_tracking_url
                  ├─ max_allowed_file_size
                  └─ preview_markdown_path
```

### データフロー図

```
[入力]                     [処理]                           [出力]

ブラウザリクエスト ───▶ ModelsController ───▶ HTML レスポンス
                              │
                              ▼
                      index_ml_model_data
                              │
                              ▼
              ┌───────────────┴───────────────┐
              ▼                               ▼
        Vue Component                   GraphQL API
        (フロントエンド)               (データ取得)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| models_controller.rb | `app/controllers/projects/ml/models_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| index.html.haml | `app/views/projects/ml/models/index.html.haml` | ビュー | 画面テンプレート |
| model.rb | `app/models/ml/model.rb` | モデル | モデルデータモデル |
| model_version.rb | `app/models/ml/model_version.rb` | モデル | バージョンデータモデル |
| model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | ヘルパー | データ整形関数 |
| mlflow_helper.rb | `app/helpers/projects/ml/mlflow_helper.rb` | ヘルパー | MLflow URL生成 |
