# 画面設計書 106-モデル新規作成

## 概要

本ドキュメントは、GitLabのMLモデル新規作成画面の設計仕様を定義するものです。

### 本画面の処理概要

モデル新規作成画面は、MLモデルレジストリに新しいモデルを登録するための画面です。モデル名と説明を入力し、新規モデルを作成します。

**業務上の目的・背景**：機械学習プロジェクトにおいて、学習済みモデルをレジストリに登録することで、モデルのバージョン管理と再利用が可能になります。本画面は、モデル登録の入力インターフェースを提供し、命名規則に従った適切なモデル名の設定を支援します。

**画面へのアクセス方法**：モデル一覧画面の「新規モデル作成」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. モデル名の入力（必須）
2. モデル説明の入力（任意、Markdownサポート）
3. モデルの作成実行

**画面遷移**：
- 遷移元：モデル一覧画面
- 遷移先：作成成功時 - モデル詳細画面、キャンセル時 - モデル一覧画面

**権限による表示制御**：
- `write_model_registry`権限：画面アクセスおよびモデル作成に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 135 | MLモデルレジストリ | 主機能 | 新規MLモデルの登録 |

## 画面種別

登録

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/ml/models/new
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| name | 入力 | String | 必須 | モデル名（最大255文字、命名規則あり） |
| description | 入力 | String | - | モデルの説明（最大10,000文字、Markdown対応） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| モデル名入力フィールド | TextInput | モデル名を入力するフィールド |
| 説明入力フィールド | MarkdownEditor | モデル説明を入力するMarkdownエディタ |
| 作成ボタン | Button | モデルを作成するボタン |
| キャンセルボタン | Button | 作成をキャンセルして一覧に戻るボタン |

## イベント仕様

### 1-モデル作成実行

作成ボタンをクリックすると、入力内容が検証された後、GraphQL APIを通じてモデルが作成されます。

### 2-キャンセル

キャンセルボタンをクリックすると、モデル一覧画面に戻ります。

### 3-Markdownプレビュー

説明フィールドでプレビューボタンをクリックすると、Markdownがレンダリングされたプレビューが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| モデル作成 | ml_models | INSERT | 新規モデルレコードの作成 |
| モデル作成 | ml_experiments | INSERT | デフォルト実験の自動作成 |

### テーブル別更新項目詳細

#### ml_models

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | 入力されたモデル名 | 命名規則検証あり |
| INSERT | description | 入力された説明文 | Markdown形式 |
| INSERT | project_id | 現在のプロジェクトID | - |
| INSERT | user_id | 現在のユーザーID | - |

#### ml_experiments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | `[model]{モデル名}` | プレフィックス付き |
| INSERT | project_id | 現在のプロジェクトID | - |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| エラー | - | Name is invalid |
| エラー | - | Name is too long (maximum is 255 characters) |
| エラー | - | Name has already been taken |
| エラー | - | Description is too long (maximum is 10000 characters) |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 404エラーを返却 |
| バリデーションエラー | エラーメッセージを表示し、入力内容を保持 |
| 名前重複 | エラーメッセージを表示 |

## 備考

- モデル名は`Gitlab::Regex.ml_model_name_regex`に従う必要があります
- モデル作成時にデフォルト実験が自動的に作成されます（`[model]`プレフィックス付き）
- Markdown説明のプレビュー機能が提供されています
- GraphQL MutationによってVueフロントエンドからモデルが作成されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、モデル作成で扱うデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | model.rb | `app/models/ml/model.rb` | バリデーション（name, description）を理解する |

**読解のコツ**: `validates :name`と`validates :description`のバリデーションルールを確認。`EXPERIMENT_NAME_PREFIX`によるデフォルト実験との連携を理解。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | models_controller.rb | `app/controllers/projects/ml/models_controller.rb` | newアクションがエントリーポイント |

**主要処理フロー**:
1. **行7**: `authorize_write_model_registry!`で権限チェック
2. **行15**: newアクション（空メソッド - ビューに処理委譲）

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.html.haml | `app/views/projects/ml/models/new.html.haml` | Vueコンポーネントをマウントするテンプレート |
| 3-2 | model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | new_ml_model_data関数でデータ整形 |

**主要処理フロー**:
- **行4**: `#js-mount-new-ml-model`にdata属性を設定
- **行21-29**: new_ml_model_dataでVueコンポーネント用データ生成

### プログラム呼び出し階層図

```
ModelsController#new
    │
    ├─ authorize_write_model_registry! (権限チェック)
    │
    └─ render new.html.haml
           │
           └─ new_ml_model_data (Helper)
                  ├─ index_models_path
                  ├─ projectPath
                  ├─ can_write_model_registry
                  └─ markdown_preview_path
```

### データフロー図

```
[入力]                     [処理]                           [出力]

ブラウザリクエスト ───▶ ModelsController#new ───▶ HTML レスポンス
                              │
                              ▼
                      new_ml_model_data
                              │
                              ▼
                      Vue Component (フォーム)
                              │
                              ▼
                      GraphQL Mutation (作成)
                              │
                              ▼
                      Ml::Model.create!
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| models_controller.rb | `app/controllers/projects/ml/models_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| new.html.haml | `app/views/projects/ml/models/new.html.haml` | ビュー | 画面テンプレート |
| model.rb | `app/models/ml/model.rb` | モデル | モデルデータモデル・バリデーション |
| model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | ヘルパー | データ整形関数 |
