# 画面設計書 107-モデル詳細

## 概要

本ドキュメントは、GitLabのMLモデル詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

モデル詳細画面は、特定のMLモデルの詳細情報とバージョン一覧を表示し、モデルのライフサイクル管理を行うための画面です。モデルのメタデータ確認、バージョン管理、モデルの編集・削除操作を提供します。

**業務上の目的・背景**：機械学習プロジェクトにおいて、登録されたモデルの詳細情報を確認し、バージョン履歴を追跡することは、モデルの運用管理に不可欠です。本画面は、モデルの概要、バージョン一覧、各バージョンへのナビゲーションを提供し、モデルライフサイクル全体の可視化を実現します。

**画面へのアクセス方法**：モデル一覧画面から特定のモデルを選択、または直接URLでアクセスします。

**主要な操作・処理内容**：
1. モデル基本情報の表示（名前、説明、最新バージョン）
2. バージョン一覧の表示
3. バージョン詳細画面への遷移
4. 新規バージョン作成画面への遷移
5. モデル編集画面への遷移
6. モデルの削除

**画面遷移**：
- 遷移元：モデル一覧画面
- 遷移先：バージョン詳細画面、バージョン新規作成画面、モデル編集画面、モデル一覧画面（削除後）

**権限による表示制御**：
- `read_model_registry`権限：画面閲覧に必要
- `write_model_registry`権限：編集・削除・バージョン作成に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 135 | MLモデルレジストリ | 主機能 | MLモデルの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/ml/models/:model_id
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| model_id | 入力 | Integer | 必須 | モデルのID |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| モデル名 | String | モデルの識別名 |
| 説明 | String | モデルの説明（Markdownレンダリング） |
| 最新バージョン | String | 最新のバージョン番号 |
| バージョン一覧 | Array | モデルに含まれるバージョンのリスト |
| MLflow Tracking URL | String | MLflow互換APIのURL |
| 作成日時 | DateTime | モデルが作成された日時 |

## イベント仕様

### 1-バージョン詳細表示

バージョン行をクリックすると、該当バージョンの詳細画面に遷移します。

### 2-新規バージョン作成

「新規バージョン作成」ボタンをクリックすると、バージョン新規作成画面に遷移します。

### 3-モデル編集

「編集」ボタンをクリックすると、モデル編集画面に遷移します。

### 4-モデル削除

「削除」ボタンをクリックすると、確認後にモデルが削除されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | ml_models | SELECT | モデル情報の取得 |
| 画面表示 | ml_model_versions | SELECT | バージョン一覧の取得 |
| モデル削除 | ml_models | DELETE | モデルの削除 |
| モデル削除 | ml_model_versions | DELETE | 関連バージョンの削除（CASCADE） |
| モデル削除 | ml_experiments | DELETE | デフォルト実験の削除 |

### テーブル別更新項目詳細

#### ml_models

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | 指定されたmodel_id | - |
| DELETE | id | 指定されたmodel_id | - |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 成功 | - | Model removed |
| 情報 | - | No versions found |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| モデルが見つからない | 404エラーを返却 |
| 権限不足 | 404エラーを返却 |

## 備考

- モデル削除時は関連するバージョンとデフォルト実験も削除されます
- バージョンはセマンティックバージョニング形式（semver）で管理されます
- MLflow Tracking URLを通じて外部からバージョンを追加可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、モデルとバージョンのデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | model.rb | `app/models/ml/model.rb` | モデルエンティティとバージョンとの関連を理解する |
| 1-2 | model_version.rb | `app/models/ml/model_version.rb` | バージョンの構造、セマンティックバージョニングを理解する |

**読解のコツ**: `has_one :latest_version`と`has_many :versions`の関連を確認。`latest_by_model`スコープで最新バージョンの取得方法を確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | models_controller.rb | `app/controllers/projects/ml/models_controller.rb` | showアクションがエントリーポイント |

**主要処理フロー**:
1. **行6**: `authorize_read_model_registry!`で権限チェック
2. **行8**: `set_model`でモデルをロード
3. **行17**: showアクション（空メソッド - ビューに処理委譲）
4. **行21-27**: destroyアクション - モデル削除処理

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/ml/models/show.html.haml` | Vueコンポーネントをマウントするテンプレート |
| 3-2 | model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | show_ml_model_data関数でデータ整形 |

**主要処理フロー**:
- **行5**: `#js-mount-show-ml-model`にdata属性を設定
- **行32-50**: show_ml_model_dataでVueコンポーネント用データ生成

### プログラム呼び出し階層図

```
ModelsController#show
    │
    ├─ authorize_read_model_registry! (権限チェック)
    │
    ├─ set_model
    │      └─ Ml::Model.by_project_id_and_id
    │
    └─ render show.html.haml
           │
           └─ show_ml_model_data (Helper)
                  ├─ projectPath
                  ├─ index_models_path
                  ├─ edit_model_path
                  ├─ create_model_version_path
                  ├─ can_write_model_registry
                  ├─ mlflow_tracking_url
                  ├─ model_id, model_name
                  ├─ max_allowed_file_size
                  ├─ latest_version
                  └─ markdown_preview_path
```

### データフロー図

```
[入力]                     [処理]                           [出力]

model_id ────────▶ ModelsController#show ────▶ HTML レスポンス
                              │
                              ▼
                      set_model
                              │
                              ▼
                      Ml::Model.by_project_id_and_id
                              │
                              ▼
              ┌───────────────┴───────────────┐
              ▼                               ▼
        Vue Component                   GraphQL API
        (フロントエンド)               (バージョン取得)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| models_controller.rb | `app/controllers/projects/ml/models_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| show.html.haml | `app/views/projects/ml/models/show.html.haml` | ビュー | 画面テンプレート |
| model.rb | `app/models/ml/model.rb` | モデル | モデルデータモデル |
| model_version.rb | `app/models/ml/model_version.rb` | モデル | バージョンデータモデル |
| model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | ヘルパー | データ整形関数 |
| mlflow_helper.rb | `app/helpers/projects/ml/mlflow_helper.rb` | ヘルパー | MLflow URL生成 |
