# 画面設計書 108-モデル編集

## 概要

本ドキュメントは、GitLabのMLモデル編集画面の設計仕様を定義するものです。

### 本画面の処理概要

モデル編集画面は、既存のMLモデルの情報（名前、説明）を編集するための画面です。モデルの説明文を更新し、モデルのドキュメンテーションを維持します。

**業務上の目的・背景**：機械学習プロジェクトにおいて、モデルの説明や用途が変更された場合、ドキュメントを最新の状態に保つことが重要です。本画面は、モデルの説明文を編集するためのインターフェースを提供し、モデルレジストリの情報品質を維持します。

**画面へのアクセス方法**：モデル詳細画面の「編集」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. モデル名の表示（編集不可）
2. モデル説明の編集（Markdownサポート）
3. 変更の保存

**画面遷移**：
- 遷移元：モデル詳細画面
- 遷移先：保存成功時 - モデル詳細画面、キャンセル時 - モデル詳細画面

**権限による表示制御**：
- `write_model_registry`権限：画面アクセスおよび編集に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 135 | MLモデルレジストリ | 主機能 | MLモデルの編集 |

## 画面種別

編集

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/ml/models/:model_id/edit
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| model_id | 入力 | Integer | 必須 | モデルのID |
| description | 入力 | String | - | モデルの説明（最大10,000文字、Markdown対応） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| モデル名 | String | モデルの識別名（読み取り専用） |
| 説明入力フィールド | MarkdownEditor | モデル説明を編集するMarkdownエディタ |
| 保存ボタン | Button | 変更を保存するボタン |
| キャンセルボタン | Button | 編集をキャンセルして詳細に戻るボタン |

## イベント仕様

### 1-変更保存

保存ボタンをクリックすると、入力内容が検証された後、GraphQL APIを通じてモデルが更新されます。

### 2-キャンセル

キャンセルボタンをクリックすると、モデル詳細画面に戻ります。

### 3-Markdownプレビュー

説明フィールドでプレビューボタンをクリックすると、Markdownがレンダリングされたプレビューが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | ml_models | SELECT | モデル情報の取得 |
| 変更保存 | ml_models | UPDATE | モデル説明の更新 |

### テーブル別更新項目詳細

#### ml_models

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | description | 入力された説明文 | Markdown形式 |
| UPDATE | description_html | レンダリング済みHTML | cache_markdown_field |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 成功 | - | Model updated successfully |
| エラー | - | Description is too long (maximum is 10000 characters) |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| モデルが見つからない | 404エラーを返却 |
| 権限不足 | 404エラーを返却 |
| バリデーションエラー | エラーメッセージを表示し、入力内容を保持 |

## 備考

- モデル名は編集できません（一意性制約のため）
- Markdown説明のプレビュー機能が提供されています
- 説明は`cache_markdown_field`によりHTMLにレンダリングされキャッシュされます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、モデル編集で扱うデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | model.rb | `app/models/ml/model.rb` | descriptionのバリデーションとcache_markdown_fieldを理解する |

**読解のコツ**: `cache_markdown_field :description`により、Markdownがレンダリング済みHTMLとしてキャッシュされる仕組みを確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | models_controller.rb | `app/controllers/projects/ml/models_controller.rb` | editアクションがエントリーポイント |

**主要処理フロー**:
1. **行7**: `authorize_write_model_registry!`で権限チェック
2. **行8**: `set_model`でモデルをロード
3. **行19**: editアクション（空メソッド - ビューに処理委譲）

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.html.haml | `app/views/projects/ml/models/edit.html.haml` | Vueコンポーネントをマウントするテンプレート |
| 3-2 | model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | edit_ml_model_data関数でデータ整形 |

**主要処理フロー**:
- **行5**: `#js-mount-edit-ml-model`にdata属性を設定
- **行52-66**: edit_ml_model_dataでVueコンポーネント用データ生成

### プログラム呼び出し階層図

```
ModelsController#edit
    │
    ├─ authorize_write_model_registry! (権限チェック)
    │
    ├─ set_model
    │      └─ Ml::Model.by_project_id_and_id
    │
    └─ render edit.html.haml
           │
           └─ edit_ml_model_data (Helper)
                  ├─ projectPath
                  ├─ can_write_model_registry
                  ├─ markdown_preview_path
                  ├─ model_path
                  ├─ model_id
                  ├─ model_name
                  └─ model_description
```

### データフロー図

```
[入力]                     [処理]                           [出力]

model_id ────────▶ ModelsController#edit ────▶ HTML レスポンス
                              │
                              ▼
                      set_model
                              │
                              ▼
                      Ml::Model.by_project_id_and_id
                              │
                              ▼
                      Vue Component (フォーム)
                              │
                              ▼
                      GraphQL Mutation (更新)
                              │
                              ▼
                      Ml::Model.update!
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| models_controller.rb | `app/controllers/projects/ml/models_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| edit.html.haml | `app/views/projects/ml/models/edit.html.haml` | ビュー | 画面テンプレート |
| model.rb | `app/models/ml/model.rb` | モデル | モデルデータモデル・バリデーション |
| model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | ヘルパー | データ整形関数 |
