# 画面設計書 109-モデルバージョン詳細

## 概要

本ドキュメントは、GitLabのMLモデルバージョン詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

モデルバージョン詳細画面は、特定のMLモデルバージョンの詳細情報を表示し、バージョン固有のメタデータやアーティファクトを管理するための画面です。バージョンの説明、関連する候補（Run）、ファイルアーティファクトの確認を提供します。

**業務上の目的・背景**：機械学習プロジェクトにおいて、各モデルバージョンの詳細（学習パラメータ、評価メトリクス、アーティファクト）を追跡することは、モデルの再現性と品質管理に不可欠です。本画面は、特定バージョンに関するすべての情報を一元表示し、バージョン間の比較やロールバックの判断を支援します。

**画面へのアクセス方法**：モデル詳細画面からバージョンを選択、または直接URLでアクセスします。

**主要な操作・処理内容**：
1. バージョン基本情報の表示（バージョン番号、説明）
2. 関連候補（Run/Candidate）の表示
3. アーティファクト（モデルファイル）のインポート
4. バージョン編集画面への遷移

**画面遷移**：
- 遷移元：モデル詳細画面
- 遷移先：バージョン編集画面、モデル詳細画面

**権限による表示制御**：
- `read_model_registry`権限：画面閲覧に必要
- `write_model_registry`権限：編集・アーティファクトインポートに必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 135 | MLモデルレジストリ | 主機能 | モデルバージョンの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/ml/models/:model_id/versions/:model_version_id
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| model_id | 入力 | Integer | 必須 | モデルのID |
| model_version_id | 入力 | Integer | 必須 | モデルバージョンのID |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| モデル名 | String | 親モデルの識別名 |
| バージョン番号 | String | セマンティックバージョン（例: 1.0.0） |
| 説明 | String | バージョンの説明（Markdownレンダリング） |
| 関連候補 | Link | このバージョンに関連する候補へのリンク |
| メタデータ | Array | バージョン固有のメタデータ一覧 |
| アーティファクト | FileList | アップロードされたモデルファイル一覧 |
| 作成日時 | DateTime | バージョンが作成された日時 |

## イベント仕様

### 1-バージョン編集

「編集」ボタンをクリックすると、バージョン編集画面に遷移します。

### 2-アーティファクトインポート

アーティファクトインポート機能でモデルファイルをアップロードできます。API経由でファイルが追加されます。

### 3-モデル詳細への戻り

パンくずリストまたは「戻る」ボタンでモデル詳細画面に戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | ml_model_versions | SELECT | バージョン情報の取得 |
| 画面表示 | ml_model_version_metadata | SELECT | メタデータの取得 |
| 画面表示 | ml_candidates | SELECT | 関連候補の取得 |

### テーブル別更新項目詳細

本画面は主に参照系操作であり、直接的なデータ更新は発生しません（アーティファクトインポートはAPI経由）。

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 情報 | - | No artifacts found |
| 情報 | - | No metadata found |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バージョンが見つからない | 404エラーを返却 |
| 権限不足 | 404エラーを返却 |

## 備考

- バージョン番号はセマンティックバージョニング（semver）形式で検証されます
- アーティファクトインポートにはファイルサイズ制限があります（`ml_model_max_file_size`）
- 候補（Candidate）との1対1関係があり、バージョンに紐づく学習履歴を追跡可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、モデルバージョンで扱うデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | model_version.rb | `app/models/ml/model_version.rb` | バージョンエンティティ、セマンティックバージョニング、パッケージとの関連を理解する |
| 1-2 | model_version_metadata.rb | `app/models/ml/model_version_metadata.rb` | メタデータの構造を理解する |

**読解のコツ**: `include SemanticVersionable`によるバージョン番号の検証、`belongs_to :package`によるアーティファクト管理を確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | model_versions_controller.rb | `app/controllers/projects/ml/model_versions_controller.rb` | showアクションがエントリーポイント |

**主要処理フロー**:
1. **行7**: `authorize_read_model_registry!`で権限チェック
2. **行9**: `set_model_version`でバージョンをロード
3. **行11**: showアクション（空メソッド - ビューに処理委譲）
4. **行31-37**: set_model_versionでバージョンと親モデルをロード

#### Step 3: ビューとヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.html.haml | `app/views/projects/ml/model_versions/show.html.haml` | Vueコンポーネントをマウントするテンプレート |
| 3-2 | model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | show_ml_model_version_data関数でデータ整形 |

**主要処理フロー**:
- **行6**: `#js-mount-show-ml-model-version`にdata属性を設定
- **行83-102**: show_ml_model_version_dataでVueコンポーネント用データ生成

### プログラム呼び出し階層図

```
ModelVersionsController#show
    │
    ├─ authorize_read_model_registry! (権限チェック)
    │
    ├─ set_model_version
    │      ├─ Ml::ModelVersion.by_project_id_and_id
    │      └─ @model = @model_version.model
    │
    └─ render show.html.haml
           │
           └─ show_ml_model_version_data (Helper)
                  ├─ project_path
                  ├─ model_id
                  ├─ model_version_id
                  ├─ model_name
                  ├─ version_name
                  ├─ can_write_model_registry
                  ├─ import_path
                  ├─ model_path
                  ├─ edit_model_version_path
                  ├─ max_allowed_file_size
                  └─ markdown_preview_path
```

### データフロー図

```
[入力]                     [処理]                           [出力]

model_version_id ──▶ ModelVersionsController ──▶ HTML レスポンス
                              │
                              ▼
                      set_model_version
                              │
                              ▼
                      Ml::ModelVersion.by_project_id_and_id
                              │
                              ▼
              ┌───────────────┴───────────────┐
              ▼                               ▼
        Vue Component                   GraphQL API
        (フロントエンド)               (詳細データ取得)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| model_versions_controller.rb | `app/controllers/projects/ml/model_versions_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| show.html.haml | `app/views/projects/ml/model_versions/show.html.haml` | ビュー | 画面テンプレート |
| model_version.rb | `app/models/ml/model_version.rb` | モデル | バージョンデータモデル |
| model_version_metadata.rb | `app/models/ml/model_version_metadata.rb` | モデル | メタデータモデル |
| model_registry_helper.rb | `app/helpers/projects/ml/model_registry_helper.rb` | ヘルパー | データ整形関数 |
