# 画面設計書 110-候補詳細

## 概要

本ドキュメントは、GitLabのML候補（Run/Candidate）詳細画面の設計仕様を定義するものです。

### 本画面の処理概要

候補詳細画面は、機械学習実験における個々の学習実行（Run/Candidate）の詳細情報を表示し、学習結果の分析とモデル選定を支援するための画面です。パラメータ、メトリクス、メタデータ、アーティファクト、CI/CDジョブとの関連など、学習実行に関するすべての情報を一元表示します。

**業務上の目的・背景**：機械学習プロジェクトにおいて、各学習実行の詳細（ハイパーパラメータ、評価メトリクス、アーティファクト）を詳細に確認することは、最適なモデル選定と結果の再現性確保に不可欠です。本画面は、MLflow互換の候補追跡機能と統合し、学習実行の完全なトレーサビリティを提供します。

**画面へのアクセス方法**：実験詳細画面から候補を選択、または直接URLでアクセスします。

**主要な操作・処理内容**：
1. 候補基本情報の表示（IID、EID、ステータス）
2. パラメータ一覧の表示
3. メトリクス一覧の表示（時系列データ含む）
4. メタデータ一覧の表示
5. アーティファクト（パッケージ）へのリンク
6. CI/CDジョブとの関連表示
7. モデルバージョンへのプロモート
8. 候補の削除

**画面遷移**：
- 遷移元：実験詳細画面
- 遷移先：CI/CDジョブ詳細画面、アーティファクト画面、実験詳細画面（削除後）

**権限による表示制御**：
- `read_model_experiments`権限：画面閲覧に必要
- `write_model_experiments`権限：削除に必要
- `write_model_registry`権限：モデルへのプロモートに必要
- `read_build`権限：CI/CDジョブ情報の表示に必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 135 | MLモデルレジストリ | 主機能 | ML候補（実験結果）の詳細表示 |

## 画面種別

詳細

## URL/ルーティング

```
GET /:namespace_id/:project_id/-/ml/candidates/:iid
```

## 入出力項目

| 項目名 | 種別 | データ型 | 必須 | 説明 |
|--------|------|----------|------|------|
| iid | 入力 | Integer | 必須 | 候補の内部ID |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| 候補IID | Integer | 内部識別番号 |
| 候補EID | String | 外部識別子（UUID） |
| ステータス | Enum | 実行状態（running, scheduled, finished, failed, killed） |
| 実験名 | String | 所属する実験の名前 |
| パラメータ一覧 | Array | ログされたパラメータ（key-value） |
| メトリクス一覧 | Array | ログされたメトリクス（名前、値、ステップ） |
| メタデータ一覧 | Array | 追加メタデータ（key-value） |
| アーティファクト | Link | 関連パッケージへのリンク |
| CI Job | Link | 関連するCI/CDジョブへのリンク |
| 作成者 | User | 候補を作成したユーザー |
| 作成日時 | DateTime | 候補が作成された日時 |
| マージリクエスト | Link | 関連するMRへのリンク（CI経由の場合） |

## イベント仕様

### 1-アーティファクト表示

アーティファクトリンクをクリックすると、関連パッケージ詳細画面に遷移します。

### 2-CI Job表示

CI Jobリンクをクリックすると、該当ジョブの詳細画面に遷移します。

### 3-プロモート

プロモートボタンをクリックすると、候補をモデルバージョンとして登録します（write_model_registry権限必要）。

### 4-候補削除

削除ボタンをクリックすると、確認後に候補が削除されます。モデルバージョンに関連付けられた候補は削除できません。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | ml_candidates | SELECT | 候補情報の取得 |
| 画面表示 | ml_candidate_params | SELECT | パラメータの取得 |
| 画面表示 | ml_candidate_metrics | SELECT | メトリクスの取得 |
| 画面表示 | ml_candidate_metadata | SELECT | メタデータの取得 |
| 候補削除 | ml_candidates | DELETE | 候補の削除 |

### テーブル別更新項目詳細

#### ml_candidates

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iid (internal_id) | 指定されたiid | - |
| DELETE | id | 指定された候補ID | model_version_idがnullの場合のみ |

## メッセージ仕様

| 種別 | メッセージID | メッセージ内容 |
|------|-------------|---------------|
| 成功 | - | Run removed |
| エラー | - | Failed to remove run |
| エラー | - | Cannot delete a candidate associated to a model version |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 候補が見つからない | 404エラーを返却 |
| 権限不足 | 404エラーを返却 |
| モデルバージョン関連候補の削除試行 | エラーメッセージ表示、削除中止 |

## 備考

- CI/CDパイプラインから自動生成された候補の場合、`from_ci?`がtrueとなります
- プロモート機能は、候補がml_modelパッケージを持ち、かつmodel_version_idがnullの場合のみ利用可能
- CandidateDetailsPresenterでデータがJSON形式に整形されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、候補で扱うデータモデルを理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | candidate.rb | `app/models/ml/candidate.rb` | 候補エンティティ、ステータス、パラメータ・メトリクス関連を理解する |
| 1-2 | candidate_metric.rb | `app/models/ml/candidate_metric.rb` | メトリクスの構造を理解する |
| 1-3 | candidate_param.rb | `app/models/ml/candidate_param.rb` | パラメータの構造を理解する |
| 1-4 | candidate_metadata.rb | `app/models/ml/candidate_metadata.rb` | メタデータの構造を理解する |

**読解のコツ**: Candidateモデルの`status` enum、`from_ci?`メソッド、`check_model_version`コールバックを確認。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | candidates_controller.rb | `app/controllers/projects/ml/candidates_controller.rb` | showアクションがエントリーポイント |

**主要処理フロー**:
1. **行6**: `set_candidate`で候補をロード
2. **行7**: `check_read`で権限チェック
3. **行12**: showアクション（空メソッド - ビューに処理委譲）
4. **行16-25**: destroyアクション - 候補削除処理

#### Step 3: プレゼンターを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | candidate_details_presenter.rb | `app/presenters/ml/candidate_details_presenter.rb` | Vueコンポーネント用にデータを整形するプレゼンター |

**主要処理フロー**:
- **行10-41**: presentメソッドで候補の全データを構造化
- **行44-46**: present_as_jsonでJSON形式に変換

#### Step 4: ビューを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | show.html.haml | `app/views/projects/ml/candidates/show.html.haml` | Vueコンポーネントをマウントするテンプレート |

**主要処理フロー**:
- **行6**: CandidateDetailsPresenterを生成
- **行8**: `#js-show-ml-candidate`にdata属性を設定

### プログラム呼び出し階層図

```
CandidatesController#show
    │
    ├─ set_candidate
    │      └─ Ml::Candidate.with_project_id_and_iid
    │
    ├─ check_read (権限チェック)
    │
    └─ render show.html.haml
           │
           └─ CandidateDetailsPresenter.new
                  │
                  ├─ present
                  │      ├─ link_to_artifact
                  │      ├─ link_to_experiment
                  │      ├─ job_info
                  │      │      ├─ user_info
                  │      │      └─ mr_info
                  │      └─ can_promote
                  │
                  └─ present_as_json
```

### データフロー図

```
[入力]                     [処理]                           [出力]

iid ──────────────▶ CandidatesController ──────▶ HTML レスポンス
                              │
                              ▼
                      set_candidate
                              │
                              ▼
                      Ml::Candidate.with_project_id_and_iid
                              │
                              ▼
                      CandidateDetailsPresenter
                              │
                              ▼
              ┌───────────────┴───────────────┐
              ▼                               ▼
        Vue Component               CI/CD Build Info
        (フロントエンド)            (ジョブ関連)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| candidates_controller.rb | `app/controllers/projects/ml/candidates_controller.rb` | コントローラ | リクエスト処理のエントリーポイント |
| show.html.haml | `app/views/projects/ml/candidates/show.html.haml` | ビュー | 画面テンプレート |
| candidate.rb | `app/models/ml/candidate.rb` | モデル | 候補データモデル |
| candidate_metric.rb | `app/models/ml/candidate_metric.rb` | モデル | メトリクスデータモデル |
| candidate_param.rb | `app/models/ml/candidate_param.rb` | モデル | パラメータデータモデル |
| candidate_metadata.rb | `app/models/ml/candidate_metadata.rb` | モデル | メタデータモデル |
| candidate_details_presenter.rb | `app/presenters/ml/candidate_details_presenter.rb` | プレゼンター | データ整形・JSON変換 |
